/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.datasource;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Props;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.data.datasource.UntransactionDataSource;
import org.noear.solon.lang.Nullable;

public class DsUtils {
    public static final String[] DEFAULT_CLASS_PROP_NAMES = new String[]{"@type", "type", "class", "dataSourceClassName"};
    public static final String UNTRANSACTION_PROP_NAME = "untransaction";

    private static Class<?> resolveTypeOrNull(Properties props, String[] typePropNames) {
        String typeStr = Utils.propertyOr((Properties)props, (String[])typePropNames);
        if (Utils.isNotEmpty((String)typeStr)) {
            Utils.propertyRemove((Properties)props, (String[])typePropNames);
            Class typeClz = ClassUtil.loadClass((String)typeStr);
            if (typeClz == null || !DataSource.class.isAssignableFrom(typeClz)) {
                throw new IllegalStateException("The type configuration is not a data source");
            }
            return typeClz;
        }
        return null;
    }

    private static Class<?> resolveTypeOrDefault(Properties props, Class<?> typeDef, String[] typePropNames) {
        String typeStr = Utils.propertyOr((Properties)props, (String[])typePropNames);
        Class typeClz = null;
        if (Utils.isEmpty((String)typeStr)) {
            typeClz = typeDef;
        } else {
            Utils.propertyRemove((Properties)props, (String[])typePropNames);
            typeClz = ClassUtil.loadClass((String)typeStr);
        }
        if (typeClz == null || !DataSource.class.isAssignableFrom(typeClz)) {
            throw new IllegalStateException("The type configuration is not a data source");
        }
        return typeClz;
    }

    private static DataSource convertDo(Properties props, Class<?> typeClz) {
        DataSource ds = (DataSource)PropsConverter.global().convert(props, typeClz);
        if ("true".equals(props.getProperty(UNTRANSACTION_PROP_NAME))) {
            return new UntransactionDataSource(ds);
        }
        return ds;
    }

    public static DataSource buildDs(Properties props) {
        return DsUtils.buildDs(props, null, DEFAULT_CLASS_PROP_NAMES);
    }

    public static DataSource buildDs(Properties props, Class<?> typeDef) {
        return DsUtils.buildDs(props, typeDef, DEFAULT_CLASS_PROP_NAMES);
    }

    public static DataSource buildDs(Properties props, String[] typePropNames) {
        return DsUtils.buildDs(props, null, typePropNames);
    }

    public static DataSource buildDs(Properties props, Class<?> typeDef, String[] typePropNames) {
        Class<?> typeClz = DsUtils.resolveTypeOrDefault(props, typeDef, typePropNames);
        return DsUtils.convertDo(props, typeClz);
    }

    public static Map<String, DataSource> buildDsMap(Properties props) {
        return DsUtils.buildDsMap(props, DEFAULT_CLASS_PROP_NAMES);
    }

    public static Map<String, DataSource> buildDsMap(Properties props, Class<?> typeDef) {
        return DsUtils.buildDsMap(props, typeDef, DEFAULT_CLASS_PROP_NAMES);
    }

    public static Map<String, DataSource> buildDsMap(Properties props, String[] typePropNames) {
        Class<?> typeClz = DsUtils.resolveTypeOrNull(props, typePropNames);
        return DsUtils.buildDsMap(props, typeClz, typePropNames);
    }

    public static Map<String, DataSource> buildDsMap(Properties props, @Nullable Class<?> typeDef, String[] typePropNames) {
        Props rootProps;
        if (props instanceof Props) {
            rootProps = (Props)props;
        } else {
            rootProps = new Props();
            rootProps.putAll((Map)props);
        }
        Map groupProps = rootProps.getGroupedProp("");
        if (groupProps.size() == 0) {
            throw new IllegalStateException("Missing data source configuration");
        }
        LinkedHashMap<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
        for (Map.Entry kv : groupProps.entrySet()) {
            if (((Props)kv.getValue()).size() <= 1) continue;
            Class<?> typeClz = DsUtils.resolveTypeOrDefault((Properties)kv.getValue(), typeDef, typePropNames);
            DataSource source = DsUtils.convertDo((Properties)kv.getValue(), typeClz);
            dataSourceMap.put((String)kv.getKey(), source);
        }
        return dataSourceMap;
    }

    public static void observeDs(AppContext context, String dsName, Consumer<BeanWrap> consumer) {
        if (Utils.isEmpty((String)dsName)) {
            context.getWrapAsync(DataSource.class, dsBw -> consumer.accept((BeanWrap)dsBw));
        } else {
            context.getWrapAsync((Object)dsName, dsBw -> {
                if (dsBw.raw() instanceof DataSource) {
                    consumer.accept((BeanWrap)dsBw);
                }
            });
        }
    }
}

