/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.data.cache.CacheFactory;
import org.noear.solon.data.cache.CacheService;

public class CacheLib {
    private static Map<String, CacheService> cacheServiceMap = new HashMap<String, CacheService>();
    private static Map<String, CacheFactory> cacheFactoryMap = new HashMap<String, CacheFactory>();

    public static Map<String, CacheService> cacheServiceMap() {
        return Collections.unmodifiableMap(cacheServiceMap);
    }

    public static void cacheServiceAdd(String name, CacheService cs) {
        cacheServiceMap.put(name, cs);
    }

    public static void cacheServiceAddIfAbsent(String name, CacheService cs) {
        cacheServiceMap.putIfAbsent(name, cs);
    }

    public static CacheService cacheServiceGet(String name) {
        return cacheServiceMap.get(name);
    }

    public static void cacheFactoryAdd(String driverType, CacheFactory factory) {
        cacheFactoryMap.put(driverType, factory);
    }

    public static CacheFactory cacheFactoryGet(String driverType) {
        return cacheFactoryMap.get(driverType);
    }
}

