/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.integration;

import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Props;
import org.noear.solon.core.event.AppPluginLoadEndEvent;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.data.datasource.DsUtils;
import org.noear.solon.data.datasource.R2dbcConnectionFactory;
import org.noear.solon.vault.VaultUtils;

public class DataSourcesBuilder
implements EventListener<AppPluginLoadEndEvent> {
    public void onEvent(AppPluginLoadEndEvent e) throws Throwable {
        Props props = e.app().cfg().getProp("solon.dataSources");
        if (props.size() > 0) {
            VaultUtils.guard((Properties)props);
            this.buildDataSource(e.context(), props);
        }
    }

    private void buildDataSource(AppContext context, Props props) {
        Map<String, DataSource> dsmap = DsUtils.buildDsMap((Properties)props);
        if (dsmap.size() > 0) {
            for (Map.Entry<String, DataSource> kv : dsmap.entrySet()) {
                boolean typed = false;
                String name = kv.getKey();
                if (name.endsWith("!")) {
                    name = name.substring(0, name.length() - 1);
                    typed = true;
                }
                if (kv.getValue() instanceof R2dbcConnectionFactory) {
                    ((R2dbcConnectionFactory)kv.getValue()).register(context, name, typed);
                    continue;
                }
                BeanWrap dsBw = context.wrap(name, (Object)kv.getValue(), typed);
                context.putWrap(name, dsBw);
                if (typed) {
                    context.putWrap(DataSource.class, dsBw);
                }
                context.wrapPublish(dsBw);
                context.aot().registerEntityType(dsBw.rawClz(), null);
            }
        }
    }
}

