/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.integration;

import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.event.AppPluginLoadEndEvent;
import org.noear.solon.data.annotation.Cache;
import org.noear.solon.data.annotation.CachePut;
import org.noear.solon.data.annotation.CacheRemove;
import org.noear.solon.data.annotation.Tran;
import org.noear.solon.data.cache.CacheLib;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.CacheServiceWrapConsumer;
import org.noear.solon.data.cache.LocalCacheFactoryImpl;
import org.noear.solon.data.cache.LocalCacheService;
import org.noear.solon.data.cache.interceptor.CacheInterceptor;
import org.noear.solon.data.cache.interceptor.CachePutInterceptor;
import org.noear.solon.data.cache.interceptor.CacheRemoveInterceptor;
import org.noear.solon.data.datasource.DsUtils;
import org.noear.solon.data.datasource.R2dbcConnectionFactory;
import org.noear.solon.data.datasource.RoutingDataSource;
import org.noear.solon.data.tran.TranManager;
import org.noear.solon.data.tran.interceptor.TranInterceptor;
import org.noear.solon.vault.VaultUtils;

public class XPluginImpl
implements Plugin {
    public void start(AppContext context) {
        CacheLib.cacheFactoryAdd("local", new LocalCacheFactoryImpl());
        if (context.app().enableTransaction()) {
            TranManager.routing(RoutingDataSource.class, r -> r.determineCurrentTarget());
            context.beanInterceptorAdd(Tran.class, (Interceptor)TranInterceptor.instance, 120);
        }
        if (context.app().enableCaching()) {
            CacheLib.cacheServiceAddIfAbsent("", LocalCacheService.instance);
            context.subWrapsOfType(CacheService.class, (Consumer)new CacheServiceWrapConsumer());
            context.lifecycle(-94, () -> {
                if (!context.hasWrap(CacheService.class)) {
                    context.wrapAndPut(CacheService.class, (Object)LocalCacheService.instance);
                }
            });
            context.beanInterceptorAdd(CachePut.class, (Interceptor)new CachePutInterceptor(), 110);
            context.beanInterceptorAdd(CacheRemove.class, (Interceptor)new CacheRemoveInterceptor(), 110);
            context.beanInterceptorAdd(Cache.class, (Interceptor)new CacheInterceptor(), 111);
        }
        context.app().onEvent(AppPluginLoadEndEvent.class, e -> {
            Props props = context.cfg().getProp("solon.dataSources");
            if (props.size() > 0) {
                VaultUtils.guard((Properties)props);
                this.buildDataSource(context, props);
            }
        });
    }

    private void buildDataSource(AppContext context, Props props) {
        Map<String, DataSource> dsmap = DsUtils.buildDsMap((Properties)props);
        if (dsmap.size() > 0) {
            for (Map.Entry<String, DataSource> kv : dsmap.entrySet()) {
                boolean typed = false;
                String name = kv.getKey();
                if (name.endsWith("!")) {
                    name = name.substring(0, name.length() - 1);
                    typed = true;
                }
                if (kv.getValue() instanceof R2dbcConnectionFactory) {
                    ((R2dbcConnectionFactory)kv.getValue()).register(context, name, typed);
                    continue;
                }
                BeanWrap dsBw = context.wrap(name, (Object)kv.getValue(), typed);
                context.putWrap(name, dsBw);
                if (typed) {
                    context.putWrap(DataSource.class, dsBw);
                }
                context.wrapPublish(dsBw);
                context.aot().registerEntityType(dsBw.rawClz(), null);
            }
        }
    }
}

