/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.tran.impl;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.tran.TranNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbTranNode
implements TranNode {
    static final Logger log = LoggerFactory.getLogger(DbTranNode.class);
    protected DbTranNode parent;
    protected List<DbTranNode> children = new ArrayList<DbTranNode>();

    @Override
    public void add(TranNode slave) {
        if (slave instanceof DbTranNode) {
            DbTranNode node = (DbTranNode)slave;
            node.parent = this;
            this.children.add(node);
        }
    }

    public void commit() throws Throwable {
        for (DbTranNode n1 : this.children) {
            n1.commit();
        }
    }

    public void rollback() {
        for (DbTranNode n1 : this.children) {
            try {
                n1.rollback();
            }
            catch (Throwable e) {
                log.warn("Rollback failure", e);
            }
        }
    }

    public void close() throws Throwable {
        for (DbTranNode n1 : this.children) {
            try {
                n1.close();
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
            }
        }
    }
}

