/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sql.impl;

import java.sql.SQLException;
import org.noear.solon.data.sql.bound.RowConverter;
import org.noear.solon.data.sql.bound.RowIterator;
import org.noear.solon.data.sql.impl.StatementHolder;

class SimpleRowIterator<T>
implements RowIterator<T> {
    private final StatementHolder holder;
    private final RowConverter<T> converter;
    private T rowCurrent;
    private int rowNum = 0;

    public SimpleRowIterator(StatementHolder holder, RowConverter<T> converter) {
        this.holder = holder;
        this.converter = converter;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.holder.rsts.next()) {
                this.rowCurrent = this.converter.convert(this.holder.rsts);
                ++this.rowNum;
            } else {
                this.rowCurrent = null;
            }
            return this.rowCurrent != null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T next() {
        return this.rowCurrent;
    }

    @Override
    public long rownum() {
        return this.rowNum;
    }

    @Override
    public void remove() {
        this.close();
    }

    @Override
    public void close() {
        this.holder.close();
    }
}

