/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sql.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.noear.solon.Solon;
import org.noear.solon.data.sql.SqlCommand;
import org.noear.solon.data.sql.SqlConfiguration;
import org.noear.solon.data.sql.SqlExecutor;
import org.noear.solon.data.sql.bound.RowConverter;
import org.noear.solon.data.sql.bound.RowIterator;
import org.noear.solon.data.sql.bound.StatementBinder;
import org.noear.solon.data.sql.impl.DefaultBinder;
import org.noear.solon.data.sql.impl.SimpleRowIterator;
import org.noear.solon.data.sql.impl.StatementHolder;
import org.noear.solon.data.tran.TranUtils;

public class SimpleSqlExecutor
implements SqlExecutor {
    private static final DefaultBinder DEFAULT_BINDER = new DefaultBinder();
    private final DataSource dataSource;
    private final String commandText;
    private SqlCommand command;
    private Consumer<SqlCommand> onCommandPost;
    private Consumer<SqlCommand> onCommandAfter;

    public SimpleSqlExecutor(DataSource dataSource, String sql) {
        this.dataSource = dataSource;
        this.commandText = sql;
    }

    @Override
    public SqlExecutor params(Object ... args) {
        this.command = new SqlCommand<Object[]>(this.commandText, args, DEFAULT_BINDER);
        return this;
    }

    @Override
    public <S> SqlExecutor params(S args, StatementBinder<S> binder) {
        this.command = new SqlCommand<S>(this.commandText, args, binder);
        return this;
    }

    @Override
    public SqlExecutor params(Collection<Object[]> argsList) {
        this.command = new SqlCommand<Object[]>(this.commandText, argsList, DEFAULT_BINDER);
        return this;
    }

    @Override
    public <S> SqlExecutor params(Collection<S> argsList, Supplier<StatementBinder<S>> binderSupplier) {
        this.command = new SqlCommand<S>(this.commandText, argsList, binderSupplier.get());
        return this;
    }

    public SimpleSqlExecutor onCommandPost(Consumer<SqlCommand> action) {
        this.onCommandPost = action;
        return this;
    }

    public SimpleSqlExecutor onCommandAfter(Consumer<SqlCommand> action) {
        this.onCommandAfter = action;
        return this;
    }

    @Override
    public <T> T queryValue() throws SQLException {
        return (T)this.queryRow((ResultSet rs) -> rs.getObject(1));
    }

    @Override
    public <T> List<T> queryValueList() throws SQLException {
        return this.queryRowList((ResultSet rs) -> rs.getObject(1));
    }

    @Override
    public <T> T queryRow(Class<T> tClass) throws SQLException {
        return this.queryRow(SqlConfiguration.getConverter().create(tClass));
    }

    @Override
    public <T> T queryRow(RowConverter<T> converter) throws SQLException {
        try (StatementHolder holder = this.beginStatement(this.command, false, false);){
            holder.rsts = holder.stmt.executeQuery();
            if (holder.rsts.next()) {
                T rst = converter.convert(holder.rsts);
                this.finishStatement(this.command);
                T t = rst;
                return t;
            }
            T t = null;
            return t;
        }
    }

    @Override
    public <T> List<T> queryRowList(Class<T> tClass) throws SQLException {
        return this.queryRowList(SqlConfiguration.getConverter().create(tClass));
    }

    @Override
    public <T> List<T> queryRowList(RowConverter<T> converter) throws SQLException {
        try (StatementHolder holder = this.beginStatement(this.command, false, false);){
            holder.rsts = holder.stmt.executeQuery();
            ArrayList<T> list = new ArrayList<T>();
            while (holder.rsts.next()) {
                list.add(converter.convert(holder.rsts));
            }
            this.finishStatement(this.command);
            ArrayList<T> arrayList = list.size() > 0 ? list : null;
            return arrayList;
        }
    }

    @Override
    public <T> RowIterator<T> queryRowIterator(int fetchSize, Class<T> tClass) throws SQLException {
        return this.queryRowIterator(fetchSize, SqlConfiguration.getConverter().create(tClass));
    }

    @Override
    public <T> RowIterator<T> queryRowIterator(int fetchSize, RowConverter<T> converter) throws SQLException {
        StatementHolder holder = this.beginStatement(this.command, false, true);
        holder.stmt.setFetchSize(fetchSize);
        holder.rsts = holder.stmt.executeQuery();
        this.finishStatement(this.command);
        return new SimpleRowIterator<T>(holder, converter);
    }

    @Override
    public int update() throws SQLException {
        try (StatementHolder holder = this.beginStatement(this.command, false, false);){
            int rst = holder.stmt.executeUpdate();
            this.finishStatement(this.command);
            int n = rst;
            return n;
        }
    }

    @Override
    public <T> T updateReturnKey() throws SQLException {
        try (StatementHolder holder = this.beginStatement(this.command, true, false);){
            holder.stmt.executeUpdate();
            holder.rsts = holder.stmt.getGeneratedKeys();
            if (holder.rsts.next()) {
                Object rst = holder.rsts.getObject(1);
                this.finishStatement(this.command);
                Object object = rst;
                return (T)object;
            }
            T t = null;
            return t;
        }
    }

    @Override
    public int[] updateBatch() throws SQLException {
        try (StatementHolder holder = this.beginStatement(this.command, false, false);){
            int[] rst = holder.stmt.executeBatch();
            this.finishStatement(this.command);
            int[] nArray = rst;
            return nArray;
        }
    }

    @Override
    public <T> List<T> updateBatchReturnKeys() throws SQLException {
        try (StatementHolder holder = this.beginStatement(this.command, true, false);){
            holder.stmt.executeBatch();
            holder.rsts = holder.stmt.getGeneratedKeys();
            ArrayList<Object> keyList = new ArrayList<Object>();
            while (holder.rsts.next()) {
                keyList.add(holder.rsts.getObject(1));
            }
            this.finishStatement(this.command);
            ArrayList<Object> arrayList = keyList;
            return arrayList;
        }
    }

    protected void finishStatement(SqlCommand command) {
        if (this.onCommandAfter != null) {
            this.onCommandAfter.accept(command);
        }
    }

    protected StatementHolder beginStatement(SqlCommand command, boolean returnKeys, boolean isStream) throws SQLException {
        if (this.onCommandPost != null) {
            this.onCommandPost.accept(command);
        }
        StatementHolder holder = new StatementHolder();
        holder.conn = this.getConnection();
        holder.stmt = isStream ? (command.getSql().startsWith("{call") ? holder.conn.prepareCall(command.getSql(), 1003, 1007) : holder.conn.prepareStatement(command.getSql(), 1003, 1007)) : (returnKeys ? holder.conn.prepareStatement(command.getSql(), 1) : (command.getSql().startsWith("{call") ? holder.conn.prepareCall(command.getSql()) : holder.conn.prepareStatement(command.getSql())));
        command.fill(holder.stmt);
        return holder;
    }

    protected Connection getConnection() throws SQLException {
        if (Solon.app() == null) {
            return this.dataSource.getConnection();
        }
        return TranUtils.getConnectionProxy((DataSource)this.dataSource);
    }
}

