/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sql.impl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.data.sql.bound.RowConverter;
import org.noear.solon.data.sql.bound.RowConverterFactory;

public class DefaultConverter
implements RowConverterFactory<Object> {
    private static RowConverterFactory instance = new DefaultConverter();

    public static RowConverterFactory getInstance() {
        return instance;
    }

    public static void setInstance(RowConverterFactory instance) {
        if (instance != null) {
            DefaultConverter.instance = instance;
        }
    }

    @Override
    public RowConverter<Object> create(Class<?> tClass) {
        return new RowConverterImpl(tClass);
    }

    static {
        if (Solon.app() != null) {
            Solon.context().getBeanAsync(RowConverterFactory.class, bean -> {
                instance = bean;
            });
        }
    }

    private static class RowConverterImpl
    implements RowConverter<Object> {
        private final Class<?> tClass;
        private ResultSetMetaData metaData;

        public RowConverterImpl(Class<?> tClass) {
            this.tClass = tClass;
        }

        @Override
        public Object convert(ResultSet rs) throws SQLException {
            if (this.metaData == null) {
                this.metaData = rs.getMetaData();
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (int i = 1; i <= this.metaData.getColumnCount(); ++i) {
                String name = this.metaData.getColumnName(i);
                Object value = rs.getObject(i);
                map.put(name, value);
            }
            if (Map.class == this.tClass) {
                return map;
            }
            return ONode.load(map).toObject(this.tClass);
        }
    }
}

