/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sql.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.solon.data.sql.SqlUtils;
import org.noear.solon.data.sql.impl.CommandPrepare;
import org.noear.solon.data.sql.impl.DataIterator;
import org.noear.solon.data.tran.TranUtils;

public class SimpleSqlUtilsImpl
implements SqlUtils {
    private final DataSource dataSource;

    public SimpleSqlUtilsImpl(DataSource dataSource) {
        assert (dataSource != null);
        this.dataSource = dataSource;
    }

    protected Connection getConnection() throws SQLException {
        return TranUtils.getConnectionProxy((DataSource)this.dataSource);
    }

    protected Object getObject(CommandPrepare prepare, int idx) throws SQLException {
        return prepare.rsts.getObject(idx);
    }

    protected void setObject(PreparedStatement stmt, int idx, Object val) throws SQLException {
        if (val == null) {
            stmt.setNull(idx, 12);
        } else if (val instanceof Date) {
            if (val instanceof java.sql.Date) {
                stmt.setDate(idx, (java.sql.Date)val);
            } else if (val instanceof Timestamp) {
                stmt.setTimestamp(idx, (Timestamp)val);
            } else {
                Date v1 = (Date)val;
                stmt.setTimestamp(idx, new Timestamp(v1.getTime()));
            }
        } else {
            stmt.setObject(idx, val);
        }
    }

    protected CommandPrepare buildPrepare(String sql, Object args, boolean returnKeys, boolean isStream) throws SQLException {
        CommandPrepare prepare = new CommandPrepare(this);
        prepare.conn = this.getConnection();
        prepare.stmt = isStream ? (sql.startsWith("{call") ? prepare.conn.prepareCall(sql, 1003, 1007) : prepare.conn.prepareStatement(sql, 1003, 1007)) : (returnKeys ? prepare.conn.prepareStatement(sql, 1) : (sql.startsWith("{call") ? prepare.conn.prepareCall(sql) : prepare.conn.prepareStatement(sql)));
        if (args instanceof Collection) {
            List rowList = (List)args;
            for (Object[] row : rowList) {
                for (int i = 0; i < row.length; ++i) {
                    this.setObject(prepare.stmt, i + 1, row[i]);
                }
                prepare.stmt.addBatch();
            }
        } else {
            Object[] row = (Object[])args;
            for (int i = 0; i < row.length; ++i) {
                this.setObject(prepare.stmt, i + 1, row[i]);
            }
        }
        return prepare;
    }

    @Override
    public Object selectValue(String sql, Object ... args) throws SQLException {
        try (CommandPrepare prepare = this.buildPrepare(sql, args, false, false);){
            prepare.rsts = prepare.stmt.executeQuery();
            if (prepare.rsts.next()) {
                Object object = this.getObject(prepare, 1);
                return object;
            }
            Object var5_6 = null;
            return var5_6;
        }
    }

    @Override
    public List<Object> selectValueArray(String sql, Object ... args) throws SQLException {
        try (CommandPrepare prepare = this.buildPrepare(sql, args, false, false);){
            prepare.rsts = prepare.stmt.executeQuery();
            ArrayList<Object> list = new ArrayList<Object>();
            while (prepare.rsts.next()) {
                list.add(this.getObject(prepare, 1));
            }
            ArrayList<Object> arrayList = list.size() > 0 ? list : null;
            return arrayList;
        }
    }

    @Override
    public Map<String, Object> selectRow(String sql, Object ... args) throws SQLException {
        try (CommandPrepare prepare = this.buildPrepare(sql, args, false, false);){
            prepare.rsts = prepare.stmt.executeQuery();
            if (prepare.rsts.next()) {
                Map<String, Object> map = prepare.getRow();
                return map;
            }
            Map<String, Object> map = null;
            return map;
        }
    }

    @Override
    public List<Map<String, Object>> selectRowList(String sql, Object ... args) throws SQLException {
        try (CommandPrepare prepare = this.buildPrepare(sql, args, false, false);){
            prepare.rsts = prepare.stmt.executeQuery();
            ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
            while (prepare.rsts.next()) {
                rowList.add(prepare.getRow());
            }
            ArrayList<Map<String, Object>> arrayList = rowList.size() > 0 ? rowList : null;
            return arrayList;
        }
    }

    @Override
    public Iterator<Map<String, Object>> selectRowStream(String sql, int fetchSize, Object ... args) throws SQLException {
        CommandPrepare prepare = this.buildPrepare(sql, args, false, true);
        prepare.stmt.setFetchSize(fetchSize);
        prepare.rsts = prepare.stmt.executeQuery();
        return new DataIterator(prepare);
    }

    @Override
    public int insert(String sql, Object ... args) throws SQLException {
        try (CommandPrepare prepare = this.buildPrepare(sql, args, false, false);){
            int n = prepare.stmt.executeUpdate();
            return n;
        }
    }

    @Override
    public long insertReturnKey(String sql, Object ... args) throws SQLException {
        try (CommandPrepare prepare = this.buildPrepare(sql, args, true, false);){
            prepare.stmt.executeUpdate();
            prepare.rsts = prepare.stmt.getGeneratedKeys();
            if (prepare.rsts.next()) {
                long l = prepare.rsts.getLong(1);
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    @Override
    public int execute(String sql, Object ... args) throws SQLException {
        try (CommandPrepare prepare = this.buildPrepare(sql, args, false, false);){
            int n = prepare.stmt.executeUpdate();
            return n;
        }
    }

    @Override
    public int[] executeBatch(String sql, Collection<Object[]> argsList) throws SQLException {
        try (CommandPrepare prepare = this.buildPrepare(sql, argsList, false, false);){
            int[] nArray = prepare.stmt.executeBatch();
            return nArray;
        }
    }
}

