/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.visitor.methods;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTemplateExpression;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;

public class MathMethods {
    public static ISqlTemplateExpression atan2(SqLinkConfig config, ISqlExpression arg1, ISqlExpression arg2) {
        List<String> function;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case SQLServer: {
                function = Arrays.asList("ATN2(", ",", ")");
                break;
            }
            default: {
                function = Arrays.asList("ATAN2(", ",", ")");
            }
        }
        return factory.template(function, Arrays.asList(arg1, arg2));
    }

    public static ISqlTemplateExpression ceil(SqLinkConfig config, ISqlExpression arg) {
        List<String> function;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case SQLServer: {
                function = Arrays.asList("CEILING(", ")");
                break;
            }
            default: {
                function = Arrays.asList("CEIL(", ")");
            }
        }
        return factory.template(function, Collections.singletonList(arg));
    }

    public static ISqlTemplateExpression toDegrees(SqLinkConfig config, ISqlExpression arg) {
        List<String> function;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case Oracle: {
                function = Arrays.asList("(", " * 180 / 3.141592653589793)");
                break;
            }
            default: {
                function = Arrays.asList("DEGREES(", ")");
            }
        }
        return factory.template(function, Collections.singletonList(arg));
    }

    public static ISqlTemplateExpression toRadians(SqLinkConfig config, ISqlExpression arg) {
        List<String> function;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case Oracle: {
                function = Arrays.asList("(", " * 3.141592653589793 / 180)");
                break;
            }
            default: {
                function = Arrays.asList("RADIANS(", ")");
            }
        }
        return factory.template(function, Collections.singletonList(arg));
    }

    public static ISqlTemplateExpression log(SqLinkConfig config, ISqlExpression arg) {
        List<String> function;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case SQLServer: {
                function = Arrays.asList("LOG(", ")");
                break;
            }
            default: {
                function = Arrays.asList("LN(", ")");
            }
        }
        return factory.template(function, Collections.singletonList(arg));
    }

    public static ISqlTemplateExpression log10(SqLinkConfig config, ISqlExpression arg) {
        List<String> function;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case SQLServer: {
                function = Arrays.asList("LOG(", ",10)");
                break;
            }
            case Oracle: {
                function = Arrays.asList("LOG(10,", ")");
                break;
            }
            default: {
                function = Arrays.asList("LOG10(", ")");
            }
        }
        return factory.template(function, Collections.singletonList(arg));
    }

    public static ISqlTemplateExpression random(SqLinkConfig config) {
        List<String> function;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case Oracle: {
                function = Collections.singletonList("DBMS_RANDOM.VALUE");
                break;
            }
            case SQLite: {
                function = Collections.singletonList("ABS(RANDOM() / 10000000000000000000.0)");
                break;
            }
            case PostgreSQL: {
                function = Collections.singletonList("RANDOM()");
                break;
            }
            default: {
                function = Collections.singletonList("RAND()");
            }
        }
        return factory.template(function, Collections.emptyList());
    }

    public static ISqlTemplateExpression round(SqLinkConfig config, ISqlExpression arg) {
        List<String> function;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case SQLServer: {
                function = Arrays.asList("ROUND(", ",0)");
                break;
            }
            default: {
                function = Arrays.asList("ROUND(", ")");
            }
        }
        return factory.template(function, Collections.singletonList(arg));
    }
}

