/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.api.crud.read;

import io.github.kiryu1223.expressionTree.delegate.Func1;
import io.github.kiryu1223.expressionTree.expressions.ExprTree;
import io.github.kiryu1223.expressionTree.expressions.annos.Expr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.data.sqlink.api.crud.CRUD;
import org.noear.solon.data.sqlink.api.crud.read.EndQuery;
import org.noear.solon.data.sqlink.api.crud.read.LQuery;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlUnionsExpression;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.base.toBean.build.ObjectBuilder;
import org.noear.solon.data.sqlink.core.exception.NotCompiledException;
import org.noear.solon.data.sqlink.core.sqlBuilder.UnionBuilder;
import org.noear.solon.data.sqlink.core.visitor.SqlVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionQuery<T>
extends CRUD {
    private static final Logger log = LoggerFactory.getLogger(UnionQuery.class);
    private final UnionBuilder unionBuilder;

    public UnionQuery(SqLinkConfig config, LQuery<T> q1, LQuery<T> q2, boolean all) {
        this(config, q1.getSqlBuilder().getQueryable(), q2.getSqlBuilder().getQueryable(), all);
    }

    public UnionQuery(SqLinkConfig config, EndQuery<T> q1, EndQuery<T> q2, boolean all) {
        this(config, q1.getSqlBuilder().getQueryable(), q2.getSqlBuilder().getQueryable(), all);
    }

    public UnionQuery(SqLinkConfig config, ISqlQueryableExpression q1, ISqlQueryableExpression q2, boolean all) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        ISqlUnionsExpression unions = factory.unions();
        unions.addUnion(factory.union(q2, all));
        this.unionBuilder = new UnionBuilder(config, q1, unions, factory.orderBy(), factory.limit());
    }

    @Override
    protected SqLinkConfig getConfig() {
        return this.unionBuilder.getConfig();
    }

    public UnionQuery<T> union(LQuery<T> query, boolean all) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        ISqlQueryableExpression queryable = query.getSqlBuilder().getQueryable();
        this.unionBuilder.addUnion(factory.union(queryable, all));
        return this;
    }

    public UnionQuery<T> union(LQuery<T> query) {
        return this.union(query, false);
    }

    public UnionQuery<T> unionAll(LQuery<T> query) {
        return this.union(query, true);
    }

    public UnionQuery<T> union(EndQuery<T> query, boolean all) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        ISqlQueryableExpression queryable = query.getSqlBuilder().getQueryable();
        this.unionBuilder.addUnion(factory.union(queryable, all));
        return this;
    }

    public UnionQuery<T> union(EndQuery<T> query) {
        return this.union(query, false);
    }

    public UnionQuery<T> unionAll(EndQuery<T> query) {
        return this.union(query, true);
    }

    public <R> UnionQuery<T> orderBy(@Expr(value=Expr.BodyType.Expr) Func1<T, R> expr, boolean asc) {
        throw new NotCompiledException();
    }

    public <R> UnionQuery<T> orderBy(ExprTree<Func1<T, R>> expr, boolean asc) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.unionBuilder.getQueryable());
        Object expression = sqlVisitor.visit(expr.getTree());
        this.unionBuilder.addOrder(factory.order((ISqlExpression)expression, asc));
        return this;
    }

    public <R> UnionQuery<T> orderBy(@Expr(value=Expr.BodyType.Expr) Func1<T, R> expr) {
        throw new NotCompiledException();
    }

    public <R> UnionQuery<T> orderBy(ExprTree<Func1<T, R>> expr) {
        return this.orderBy(expr, true);
    }

    public UnionQuery<T> limit(long rows) {
        this.unionBuilder.addLimit(0L, rows);
        return this;
    }

    public UnionQuery<T> limit(long offset, long rows) {
        this.unionBuilder.addLimit(offset, rows);
        return this;
    }

    @Override
    public String toSql() {
        return this.unionBuilder.getSql();
    }

    public List<T> toList() {
        SqLinkConfig config = this.getConfig();
        ArrayList<SqlValue> sqlValues = new ArrayList<SqlValue>();
        boolean single = this.unionBuilder.isSingle();
        List mappingData = single ? Collections.emptyList() : this.unionBuilder.getMappingData();
        String sql = this.unionBuilder.getSqlAndValue(sqlValues);
        this.tryPrintSql(log, sql);
        Class targetClass = this.unionBuilder.getTargetClass();
        SqlSession session = config.getSqlSessionFactory().getSession(config);
        return session.executeQuery(r -> ObjectBuilder.start(r, targetClass, mappingData, single, config).createList(), sql, sqlValues);
    }
}

