/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlExt.pgsql;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTypeExpression;
import org.noear.solon.data.sqlink.base.sqlExt.BaseSqlExtension;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;

public class PostgreSQLCastExtension
extends BaseSqlExtension {
    @Override
    public ISqlExpression parse(SqLinkConfig config, Method method, List<ISqlExpression> args) {
        String unit;
        ArrayList<String> templates = new ArrayList<String>();
        ArrayList<ISqlExpression> sqlExpressions = new ArrayList<ISqlExpression>();
        ISqlExpression expression = args.get(1);
        ISqlTypeExpression typeExpression = (ISqlTypeExpression)expression;
        Class<?> type = typeExpression.getType();
        templates.add("");
        sqlExpressions.add(args.get(0));
        if (ExpressionUtil.isByte(type) || ExpressionUtil.isShort(type)) {
            unit = "INT2";
        } else if (ExpressionUtil.isInt(type)) {
            unit = "INT4";
        } else if (ExpressionUtil.isLong(type)) {
            unit = "INT8";
        } else if (ExpressionUtil.isFloat(type)) {
            unit = "FLOAT4";
        } else if (ExpressionUtil.isDouble(type)) {
            unit = "FLOAT8";
        } else if (ExpressionUtil.isDecimal(type)) {
            unit = "NUMERIC";
        } else if (ExpressionUtil.isChar(type)) {
            unit = "CHAR";
        } else if (ExpressionUtil.isString(type)) {
            unit = "VARCHAR";
        } else if (ExpressionUtil.isTime(type)) {
            unit = "TIME";
        } else if (ExpressionUtil.isDate(type)) {
            unit = "DATE";
        } else if (ExpressionUtil.isDateTime(type)) {
            unit = "TIMESTAMP";
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684Java\u7c7b\u578b:" + type.getName());
        }
        templates.add("::" + unit);
        return config.getSqlExpressionFactory().template(templates, sqlExpressions);
    }
}

