/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlBuilder;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlFromExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlGroupByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSelectExpression;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.base.toBean.Include.IncludeSet;
import org.noear.solon.data.sqlink.core.sqlBuilder.ISqlBuilder;

public class QuerySqlBuilder
implements ISqlBuilder {
    private final SqLinkConfig config;
    private ISqlQueryableExpression queryable;
    private final List<IncludeSet> includeSets = new ArrayList<IncludeSet>();

    public QuerySqlBuilder(SqLinkConfig config, ISqlQueryableExpression queryable) {
        this.config = config;
        this.queryable = queryable;
    }

    public void addWhere(ISqlExpression cond) {
        this.queryable.addWhere(cond);
    }

    public void addOrWhere(ISqlExpression cond) {
        if (this.queryable.getWhere().isEmpty()) {
            this.addWhere(cond);
        } else {
            SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
            this.addWhere(factory.unary(SqlOperator.OR, cond));
        }
    }

    public void setGroup(ISqlGroupByExpression group) {
        SqlExpressionFactory factory = this.config.getSqlExpressionFactory();
        this.queryable.setGroup(group);
    }

    public void addHaving(ISqlExpression cond) {
        this.queryable.addHaving(cond);
    }

    public void addOrder(ISqlOrderExpression order) {
        this.queryable.addOrder(order);
    }

    public void setSelect(ISqlSelectExpression select) {
        this.queryable.setSelect(select);
    }

    public void setSelect(Class<?> c) {
        ArrayList<ISqlExpression> expressions;
        SqlExpressionFactory factory;
        block11: {
            MetaData metaData = MetaDataCache.getMetaData(c);
            factory = this.getConfig().getSqlExpressionFactory();
            ISqlFromExpression from = this.queryable.getFrom();
            ISqlJoinsExpression joins = this.queryable.getJoins();
            expressions = new ArrayList<ISqlExpression>();
            if (from.getSqlTableExpression().getMainTableClass() == c) {
                for (FieldMetaData notIgnoreProperty : metaData.getNotIgnorePropertys()) {
                    expressions.add(factory.column(notIgnoreProperty, from.getAsName()));
                }
            } else if (joins.getJoins().stream().anyMatch(join -> join.getJoinTable().getMainTableClass() == c)) {
                for (ISqlJoinExpression join2 : joins.getJoins()) {
                    if (join2.getJoinTable().getMainTableClass() != c) continue;
                    for (FieldMetaData notIgnoreProperty : metaData.getNotIgnorePropertys()) {
                        expressions.add(factory.column(notIgnoreProperty, join2.getAsName()));
                    }
                    break;
                }
            } else {
                for (FieldMetaData sel : metaData.getNotIgnorePropertys()) {
                    MetaData mainTableMetaData = MetaDataCache.getMetaData(from.getSqlTableExpression().getMainTableClass());
                    for (FieldMetaData noi : mainTableMetaData.getNotIgnorePropertys()) {
                        if (!noi.getColumn().equals(sel.getColumn()) || !noi.getType().equals(sel.getType())) continue;
                        expressions.add(factory.column(sel, from.getAsName()));
                        break block11;
                    }
                    for (ISqlJoinExpression join3 : joins.getJoins()) {
                        MetaData joinTableMetaData = MetaDataCache.getMetaData(join3.getJoinTable().getMainTableClass());
                        for (FieldMetaData noi : joinTableMetaData.getNotIgnorePropertys()) {
                            if (!noi.getColumn().equals(sel.getColumn()) || !noi.getType().equals(sel.getType())) continue;
                            expressions.add(factory.column(sel, join3.getAsName()));
                            break block11;
                        }
                    }
                }
            }
        }
        this.queryable.setSelect(factory.select(expressions, c));
    }

    public void setLimit(long offset, long rows) {
        this.queryable.setLimit(offset, rows);
    }

    public void setDistinct(boolean distinct) {
        this.queryable.setDistinct(distinct);
    }

    @Override
    public SqLinkConfig getConfig() {
        return this.config;
    }

    @Override
    public String getSql() {
        return this.queryable.getSql(this.config);
    }

    @Override
    public String getSqlAndValue(List<SqlValue> values) {
        return this.queryable.getSqlAndValue(this.config, values);
    }

    public List<FieldMetaData> getMappingData() {
        return this.queryable.getMappingData();
    }

    public boolean isSingle() {
        return this.queryable.getSelect().isSingle();
    }

    public <T> Class<T> getTargetClass() {
        return this.queryable.getMainTableClass();
    }

    public ISqlQueryableExpression getQueryable() {
        return this.queryable;
    }

    public void setQueryable(ISqlQueryableExpression queryable) {
        this.queryable = queryable;
    }

    public List<IncludeSet> getIncludeSets() {
        return this.includeSets;
    }

    public IncludeSet getLastIncludeSet() {
        return this.includeSets.get(this.includeSets.size() - 1);
    }
}

