/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlBuilder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.SqLinkDialect;
import org.noear.solon.data.sqlink.base.expression.AsName;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlFromExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWhereExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.core.sqlBuilder.ISqlBuilder;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;

public class DeleteSqlBuilder
implements ISqlBuilder {
    private final SqLinkConfig config;
    private final ISqlFromExpression from;
    private final ISqlJoinsExpression joins;
    private final ISqlWhereExpression wheres;
    private final Set<Integer> excludes = new HashSet<Integer>();
    private final SqlExpressionFactory factory;

    public DeleteSqlBuilder(SqLinkConfig config, Class<?> target) {
        this.config = config;
        this.factory = config.getSqlExpressionFactory();
        this.joins = this.factory.Joins();
        this.wheres = this.factory.where();
        String first = ExpressionUtil.getFirst(target);
        this.from = this.factory.from(this.factory.table(target), new AsName(first));
    }

    public void addJoin(JoinType joinType, ISqlTableExpression table, ISqlExpression on) {
        ISqlJoinExpression join2;
        String first = ExpressionUtil.getFirst(table.getMainTableClass());
        HashSet<String> stringSet = new HashSet<String>(this.joins.getJoins().size() + 1);
        stringSet.add(this.from.getAsName().getName());
        for (ISqlJoinExpression join2 : this.joins.getJoins()) {
            stringSet.add(join2.getAsName().getName());
        }
        AsName asName = ExpressionUtil.doGetAsName(first, stringSet);
        join2 = this.factory.join(joinType, table, on, asName);
        this.joins.addJoin(join2);
    }

    public void addWhere(ISqlExpression where) {
        this.wheres.addCondition(where);
    }

    @Override
    public SqLinkConfig getConfig() {
        return this.config;
    }

    public boolean hasWhere() {
        return !this.wheres.isEmpty();
    }

    public ISqlFromExpression getFrom() {
        return this.from;
    }

    public ISqlJoinsExpression getJoins() {
        return this.joins;
    }

    @Override
    public String getSql() {
        return this.getSqlAndValue(null);
    }

    @Override
    public String getSqlAndValue(List<SqlValue> values) {
        SqLinkDialect disambiguation = this.config.getDisambiguation();
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("DELETE");
        strings.add(disambiguation.disambiguation(this.from.getAsName().getName()));
        strings.add(this.from.getSqlAndValue(this.config, values));
        if (!this.joins.isEmpty()) {
            strings.add(this.joins.getSqlAndValue(this.config, values));
        }
        if (!this.wheres.isEmpty()) {
            strings.add(this.wheres.getSqlAndValue(this.config, values));
        }
        return String.join((CharSequence)" ", strings);
    }
}

