/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.integration;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.solon.annotation.Inject;
import org.noear.solon.aot.RuntimeNativeRegistrar;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.data.datasource.DsUtils;
import org.noear.solon.data.sqlink.SqLink;
import org.noear.solon.data.sqlink.base.DbType;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.session.DefaultSqlSessionFactory;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.TypeHandlerManager;
import org.noear.solon.data.sqlink.core.SqLinkBuilder;
import org.noear.solon.data.sqlink.integration.aot.SqLinkRuntimeNativeRegistrar;
import org.noear.solon.data.sqlink.integration.builder.AotBeanCreatorFactory;
import org.noear.solon.data.sqlink.integration.configuration.SqLinkProperties;
import org.noear.solon.data.sqlink.integration.datasource.SolonDataSourceManager;
import org.noear.solon.data.sqlink.integration.transaction.SolonTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPluginImpl
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(XPluginImpl.class);
    private Map<String, SqLink> clients = new LinkedHashMap<String, SqLink>();

    public void start(AppContext context) throws Throwable {
        Map data = context.cfg().getGroupedProp("solon.data.sqlink");
        context.subWrapsOfType(DataSource.class, dsBw -> {
            String dsName = dsBw.name();
            Props dsProps = (Props)data.get(dsName);
            SqLinkProperties properties = dsProps == null ? new SqLinkProperties() : (SqLinkProperties)dsProps.toBean(SqLinkProperties.class);
            SolonDataSourceManager dataSourceManager = new SolonDataSourceManager();
            SolonTransactionManager transactionManager = new SolonTransactionManager(dataSourceManager);
            DefaultSqlSessionFactory sqlSessionFactory = new DefaultSqlSessionFactory(dataSourceManager, transactionManager);
            AotBeanCreatorFactory aotFastCreatorFactory = new AotBeanCreatorFactory();
            SqLink sqLink = new SqLinkBuilder().setDataSourceManager(dataSourceManager).setTransactionManager(transactionManager).setSqlSessionFactory(sqlSessionFactory).setBeanCreatorFactory(aotFastCreatorFactory).setOption(properties.bulidOption()).build();
            this.clients.put(dsName, sqLink);
            SqLinkConfig config = sqLink.getConfig();
            DsUtils.observeDs((AppContext)context, (String)dsName, beanWrap -> this.registerDataSource((BeanWrap)beanWrap, config));
        });
        context.beanInjectorAdd(Inject.class, SqLink.class, (varHolder, inject) -> {
            varHolder.required(inject.required());
            String dsName = inject.value();
            DsUtils.observeDs((AppContext)context, (String)dsName, dsBw -> {
                SqLink sqLink = this.clients.get(dsBw.name());
                varHolder.setValue((Object)sqLink);
            });
        });
        context.getBeanAsync(ITypeHandler.class, TypeHandlerManager::set);
        this.registerAot(context);
    }

    private void registerDataSource(BeanWrap beanWrap, SqLinkConfig config) {
        SolonDataSourceManager solonDataSourceManager = (SolonDataSourceManager)config.getDataSourceManager();
        solonDataSourceManager.setDataSource((DataSource)beanWrap.get());
        try (Connection connection = solonDataSourceManager.getConnection();){
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            DbType dbType = DbType.getByName(databaseProductName);
            config.setDbType(dbType);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void registerAot(AppContext context) {
        if (NativeDetector.isAotRuntime() && ClassUtil.hasClass(() -> RuntimeNativeRegistrar.class)) {
            context.wrapAndPut(SqLinkRuntimeNativeRegistrar.class, (Object)new SqLinkRuntimeNativeRegistrar());
        }
    }
}

