/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.visitor.methods;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.noear.solon.data.sqlink.base.DbType;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlBinaryExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlCollectedValueExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTemplateExpression;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;
import org.noear.solon.data.sqlink.core.exception.SqLinkException;

public class StringMethods {
    public static ISqlBinaryExpression contains(SqLinkConfig config, ISqlExpression left, ISqlExpression right) {
        List<String> functions;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case Oracle: 
            case SQLite: {
                functions = Arrays.asList("('%'||", "||'%')");
                break;
            }
            default: {
                functions = Arrays.asList("CONCAT('%',", ",'%')");
            }
        }
        ISqlTemplateExpression function = factory.template(functions, Collections.singletonList(right));
        return factory.binary(SqlOperator.LIKE, left, function);
    }

    public static ISqlBinaryExpression startsWith(SqLinkConfig config, ISqlExpression left, ISqlExpression right) {
        List<String> functions;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        List<ISqlExpression> args = Collections.singletonList(right);
        switch (config.getDbType()) {
            case SQLite: {
                functions = Arrays.asList("(", "||'%')");
                break;
            }
            default: {
                functions = Arrays.asList("CONCAT(", ",'%')");
            }
        }
        return factory.binary(SqlOperator.LIKE, left, factory.template(functions, args));
    }

    public static ISqlBinaryExpression endsWith(SqLinkConfig config, ISqlExpression left, ISqlExpression right) {
        List<String> functions;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        List<ISqlExpression> args = Collections.singletonList(right);
        switch (config.getDbType()) {
            case SQLite: {
                functions = Arrays.asList("('%'||", ")");
                break;
            }
            default: {
                functions = Arrays.asList("CONCAT('%',", ")");
            }
        }
        return factory.binary(SqlOperator.LIKE, left, factory.template(functions, args));
    }

    public static ISqlTemplateExpression length(SqLinkConfig config, ISqlExpression thiz) {
        List<String> functions;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case SQLServer: {
                functions = Arrays.asList("LEN(", ")");
                break;
            }
            case Oracle: {
                functions = Arrays.asList("NVL(LENGTH(", "),0)");
                break;
            }
            case SQLite: 
            case PostgreSQL: {
                functions = Arrays.asList("LENGTH(", ")");
                break;
            }
            default: {
                functions = Arrays.asList("CHAR_LENGTH(", ")");
            }
        }
        return factory.template(functions, Collections.singletonList(thiz));
    }

    public static ISqlTemplateExpression toUpperCase(SqLinkConfig config, ISqlExpression thiz) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        List<String> functions = Arrays.asList("UPPER(", ")");
        return factory.template(functions, Collections.singletonList(thiz));
    }

    public static ISqlTemplateExpression toLowerCase(SqLinkConfig config, ISqlExpression thiz) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        List<String> functions = Arrays.asList("LOWER(", ")");
        return factory.template(functions, Collections.singletonList(thiz));
    }

    public static ISqlTemplateExpression concat(SqLinkConfig config, ISqlExpression left, ISqlExpression right) {
        List<String> functions;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case SQLite: {
                functions = Arrays.asList("(", "||", ")");
                break;
            }
            default: {
                functions = Arrays.asList("CONCAT(", ",", ")");
            }
        }
        return factory.template(functions, Arrays.asList(left, right));
    }

    public static ISqlTemplateExpression trim(SqLinkConfig config, ISqlExpression thiz) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        List<String> functions = Arrays.asList("TRIM(", ")");
        return factory.template(functions, Collections.singletonList(thiz));
    }

    public static ISqlExpression isEmpty(SqLinkConfig config, ISqlExpression thiz) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case SQLServer: {
                return factory.parens(factory.binary(SqlOperator.EQ, factory.template(Arrays.asList("DATALENGTH(", ")"), Collections.singletonList(thiz)), factory.constString("0")));
            }
        }
        return factory.parens(factory.binary(SqlOperator.EQ, StringMethods.length(config, thiz), factory.constString("0")));
    }

    public static ISqlTemplateExpression indexOf(SqLinkConfig config, ISqlExpression thisStr, ISqlExpression subStr) {
        List<ISqlExpression> sqlExpressions;
        List<String> functions;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case SQLServer: {
                functions = Arrays.asList("CHARINDEX(", ",", ")");
                sqlExpressions = Arrays.asList(subStr, thisStr);
                break;
            }
            case PostgreSQL: {
                functions = Arrays.asList("STRPOS(", ",", ")");
                sqlExpressions = Arrays.asList(thisStr, subStr);
                break;
            }
            default: {
                functions = Arrays.asList("INSTR(", ",", ")");
                sqlExpressions = Arrays.asList(thisStr, subStr);
            }
        }
        return factory.template(functions, sqlExpressions);
    }

    public static ISqlTemplateExpression indexOf(SqLinkConfig config, ISqlExpression thisStr, ISqlExpression subStr, ISqlExpression fromIndex) {
        List<ISqlExpression> sqlExpressions;
        List<String> functions;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case SQLServer: {
                functions = Arrays.asList("CHARINDEX(", ",", ",", ")");
                sqlExpressions = Arrays.asList(subStr, thisStr, fromIndex);
                break;
            }
            case Oracle: {
                functions = Arrays.asList("INSTR(", ",", ",", ")");
                sqlExpressions = Arrays.asList(thisStr, subStr, fromIndex);
                break;
            }
            case SQLite: {
                functions = Arrays.asList("(INSTR(SUBSTR(", ",", " + 1),", ") + ", ")");
                sqlExpressions = Arrays.asList(thisStr, fromIndex, subStr, fromIndex);
                break;
            }
            case PostgreSQL: {
                functions = Arrays.asList("(STRPOS(SUBSTR(", ",", " + 1),", ") + ", ")");
                sqlExpressions = Arrays.asList(thisStr, fromIndex, subStr, fromIndex);
                break;
            }
            default: {
                functions = Arrays.asList("LOCATE(", ",", ",", ")");
                sqlExpressions = Arrays.asList(subStr, thisStr, fromIndex);
            }
        }
        return factory.template(functions, sqlExpressions);
    }

    public static ISqlTemplateExpression replace(SqLinkConfig config, ISqlExpression thisStr, ISqlExpression oldStr, ISqlExpression newStr) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        List<String> functions = Arrays.asList("REPLACE(", ",", ",", ")");
        List<ISqlExpression> sqlExpressions = Arrays.asList(thisStr, oldStr, newStr);
        return factory.template(functions, sqlExpressions);
    }

    public static ISqlTemplateExpression substring(SqLinkConfig config, ISqlExpression thisStr, ISqlExpression beginIndex) {
        List<ISqlExpression> sqlExpressions;
        List<String> functions;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        switch (config.getDbType()) {
            case SQLServer: {
                functions = Arrays.asList("SUBSTRING(", ",", ",LEN(", ") - (", " - 1))");
                sqlExpressions = Arrays.asList(thisStr, beginIndex, thisStr, beginIndex);
                break;
            }
            default: {
                functions = Arrays.asList("SUBSTR(", ",", ")");
                sqlExpressions = Arrays.asList(thisStr, beginIndex);
            }
        }
        return factory.template(functions, sqlExpressions);
    }

    public static ISqlTemplateExpression substring(SqLinkConfig config, ISqlExpression thisStr, ISqlExpression beginIndex, ISqlExpression endIndex) {
        List<String> functions;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        List<ISqlExpression> sqlExpressions = Arrays.asList(thisStr, beginIndex, endIndex);
        switch (config.getDbType()) {
            case SQLServer: {
                functions = Arrays.asList("SUBSTRING(", ",", ",", ")");
                break;
            }
            default: {
                functions = Arrays.asList("SUBSTR(", ",", ",", ")");
            }
        }
        return factory.template(functions, sqlExpressions);
    }

    public static ISqlTemplateExpression joinArray(SqLinkConfig config, ISqlExpression delimiter, List<ISqlExpression> elements) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        ArrayList<String> functions = new ArrayList<String>();
        ArrayList<ISqlExpression> sqlExpressions = new ArrayList<ISqlExpression>(1 + elements.size());
        switch (config.getDbType()) {
            case Oracle: 
            case SQLite: {
                functions.add("(");
                for (int i = 0; i < elements.size(); ++i) {
                    sqlExpressions.add(elements.get(i));
                    if (i >= elements.size() - 1) continue;
                    functions.add("||");
                    sqlExpressions.add(delimiter);
                    functions.add("||");
                }
                functions.add(")");
                break;
            }
            default: {
                sqlExpressions.add(delimiter);
                sqlExpressions.addAll(elements);
                functions.add("CONCAT_WS(");
                functions.add(",");
                for (int i = 0; i < sqlExpressions.size(); ++i) {
                    if (i >= elements.size() - 1) continue;
                    functions.add(",");
                }
                functions.add(")");
            }
        }
        return factory.template(functions, sqlExpressions);
    }

    public static ISqlTemplateExpression joinList(SqLinkConfig config, ISqlExpression delimiter, ISqlExpression elements) {
        List<ISqlExpression> sqlExpressions;
        ArrayList<String> functions;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        if (elements instanceof ISqlCollectedValueExpression) {
            if (config.getDbType() == DbType.Oracle || config.getDbType() == DbType.SQLite) {
                ISqlCollectedValueExpression expression = (ISqlCollectedValueExpression)elements;
                ArrayList collection = new ArrayList(expression.getCollection());
                functions = new ArrayList(collection.size() * 2);
                sqlExpressions = new ArrayList<ISqlExpression>(collection.size() * 2);
                functions.add("(");
                for (int i = 0; i < collection.size(); ++i) {
                    sqlExpressions.add(factory.value(collection.get(i)));
                    if (i >= collection.size() - 1) continue;
                    functions.add("||");
                    sqlExpressions.add(delimiter);
                    functions.add("||");
                }
                functions.add(")");
            } else {
                functions = new ArrayList<String>();
                sqlExpressions = Arrays.asList(delimiter, elements);
            }
        } else {
            throw new SqLinkException("String.join()\u7684\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u662fjava\u4e2d\u80fd\u83b7\u53d6\u5230\u7684");
        }
        switch (config.getDbType()) {
            case Oracle: 
            case SQLite: {
                break;
            }
            default: {
                functions.add("CONCAT_WS(");
                functions.add(",");
                functions.add(")");
            }
        }
        return factory.template(functions, sqlExpressions);
    }
}

