/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.visitor.methods;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTemplateExpression;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;

public class AggregateMethods {
    public static ISqlTemplateExpression count(SqLinkConfig config, ISqlExpression expression) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        ISqlTemplateExpression templateExpression = expression == null ? factory.template(Collections.singletonList("COUNT(*)"), Collections.emptyList()) : factory.template(Arrays.asList("COUNT(", ")"), Collections.singletonList(expression));
        return templateExpression;
    }

    public static ISqlTemplateExpression count(SqLinkConfig config) {
        return AggregateMethods.count(config, null);
    }

    public static ISqlTemplateExpression sum(SqLinkConfig config, ISqlExpression expression) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        return factory.template(Arrays.asList("SUM(", ")"), Collections.singletonList(expression));
    }

    public static ISqlTemplateExpression avg(SqLinkConfig config, ISqlExpression expression) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        return factory.template(Arrays.asList("AVG(", ")"), Collections.singletonList(expression));
    }

    public static ISqlTemplateExpression max(SqLinkConfig config, ISqlExpression expression) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        return factory.template(Arrays.asList("MAX(", ")"), Collections.singletonList(expression));
    }

    public static ISqlTemplateExpression min(SqLinkConfig config, ISqlExpression expression) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        return factory.template(Arrays.asList("MIN(", ")"), Collections.singletonList(expression));
    }

    public static ISqlTemplateExpression groupConcat(SqLinkConfig config, List<ISqlExpression> expressions) {
        List<ISqlExpression> args;
        List<String> strings;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        if (expressions.size() == 1) {
            ISqlExpression property = expressions.get(0);
            switch (config.getDbType()) {
                case SQLServer: {
                    strings = Arrays.asList("STRING_AGG(", ",',')");
                    args = Collections.singletonList(property);
                    break;
                }
                case PostgreSQL: {
                    strings = Arrays.asList("STRING_AGG(", "::TEXT,',')");
                    args = Collections.singletonList(property);
                    break;
                }
                case Oracle: {
                    strings = Arrays.asList("LISTAGG(", ") WITHIN GROUP (ORDER BY ", ")");
                    args = Arrays.asList(property, property);
                    break;
                }
                default: {
                    strings = Arrays.asList("GROUP_CONCAT(", ")");
                    args = Collections.singletonList(property);
                    break;
                }
            }
        } else {
            ISqlExpression delimiter = expressions.get(0);
            ISqlExpression property = expressions.get(1);
            switch (config.getDbType()) {
                case Oracle: {
                    strings = Arrays.asList("LISTAGG(", ",", ") WITHIN GROUP (ORDER BY ", ")");
                    args = Arrays.asList(property, delimiter, property);
                    break;
                }
                case SQLServer: {
                    strings = Arrays.asList("STRING_AGG(", ",", ")");
                    args = Arrays.asList(property, delimiter);
                }
                case PostgreSQL: {
                    strings = Arrays.asList("STRING_AGG(", "::TEXT,", ")");
                    args = Arrays.asList(property, delimiter);
                }
                case SQLite: {
                    strings = Arrays.asList("GROUP_CONCAT(", ",", ")");
                    args = Arrays.asList(property, delimiter);
                }
                default: {
                    strings = Arrays.asList("GROUP_CONCAT(", " SEPARATOR ", ")");
                    args = Arrays.asList(property, delimiter);
                }
            }
        }
        return factory.template(strings, args);
    }
}

