/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core;

import io.github.kiryu1223.expressionTree.expressions.annos.Recode;
import java.util.Collection;
import java.util.Iterator;
import org.noear.solon.data.sqlink.SqLink;
import org.noear.solon.data.sqlink.api.crud.create.ObjectInsert;
import org.noear.solon.data.sqlink.api.crud.delete.LDelete;
import org.noear.solon.data.sqlink.api.crud.read.Empty;
import org.noear.solon.data.sqlink.api.crud.read.EmptyQuery;
import org.noear.solon.data.sqlink.api.crud.read.EndQuery;
import org.noear.solon.data.sqlink.api.crud.read.LQuery;
import org.noear.solon.data.sqlink.api.crud.read.UnionQuery;
import org.noear.solon.data.sqlink.api.crud.update.LUpdate;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.AsName;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.transaction.Transaction;
import org.noear.solon.data.sqlink.core.exception.SqLinkException;
import org.noear.solon.data.sqlink.core.sqlBuilder.DeleteSqlBuilder;
import org.noear.solon.data.sqlink.core.sqlBuilder.QuerySqlBuilder;
import org.noear.solon.data.sqlink.core.sqlBuilder.UpdateSqlBuilder;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;

public class SqLinkImpl
implements SqLink {
    private final SqLinkConfig config;

    SqLinkImpl(SqLinkConfig config) {
        this.config = config;
    }

    @Override
    public Transaction beginTransaction(Integer isolationLevel) {
        return this.config.getTransactionManager().get(isolationLevel);
    }

    @Override
    public Transaction beginTransaction() {
        return this.beginTransaction(null);
    }

    @Override
    public <T> LQuery<T> query(@Recode Class<T> c) {
        String first = ExpressionUtil.getFirst(c);
        return new LQuery(new QuerySqlBuilder(this.config, this.config.getSqlExpressionFactory().queryable(c, new AsName(first))));
    }

    @Override
    public <T> UnionQuery<T> union(LQuery<T> q1, LQuery<T> q2) {
        return new UnionQuery<T>(this.config, q1, q2, false);
    }

    @Override
    public <T> UnionQuery<T> union(EndQuery<T> q1, EndQuery<T> q2) {
        return new UnionQuery<T>(this.config, q1, q2, false);
    }

    @Override
    public <T> UnionQuery<T> unionAll(LQuery<T> q1, LQuery<T> q2) {
        return new UnionQuery<T>(this.config, q1, q2, true);
    }

    @Override
    public <T> UnionQuery<T> unionAll(EndQuery<T> q1, EndQuery<T> q2) {
        return new UnionQuery<T>(this.config, q1, q2, false);
    }

    @Override
    public EmptyQuery queryEmptyTable() {
        return new EmptyQuery(new QuerySqlBuilder(this.config, this.config.getSqlExpressionFactory().queryable(Empty.class, new AsName())));
    }

    @Override
    public <T> ObjectInsert<T> insert(@Recode T t) {
        ObjectInsert objectInsert = new ObjectInsert(this.config, t.getClass());
        return objectInsert.insert(t);
    }

    @Override
    public <T> ObjectInsert<T> insert(@Recode Collection<T> ts) {
        ObjectInsert<T> objectInsert = new ObjectInsert<T>(this.config, this.getType(ts));
        return objectInsert.insert(ts);
    }

    @Override
    public <T> LUpdate<T> update(@Recode Class<T> c) {
        SqlExpressionFactory factory = this.config.getSqlExpressionFactory();
        String first = ExpressionUtil.getFirst(c);
        return new LUpdate(new UpdateSqlBuilder(this.config, factory.update(c, new AsName(first))));
    }

    @Override
    public <T> LDelete<T> delete(@Recode Class<T> c) {
        return new LDelete(new DeleteSqlBuilder(this.config, c));
    }

    @Override
    public SqLinkConfig getConfig() {
        return this.config;
    }

    private <T> Class<T> getType(Collection<T> ts) {
        Iterator<T> iterator = ts.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            return t.getClass();
        }
        throw new SqLinkException("insert\u5185\u5bb9\u4e3a\u7a7a");
    }
}

