/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.toBean.beancreator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.noear.solon.data.sqlink.base.toBean.beancreator.ISetterCaller;

public abstract class AbsBeanCreator<T> {
    protected final Class<T> target;
    protected final Supplier<T> supplier;
    protected final Map<String, ISetterCaller<T>> setters = new ConcurrentHashMap<String, ISetterCaller<T>>();

    protected AbsBeanCreator(Class<T> target) {
        this.target = target;
        this.supplier = this.initBeanCreator(target);
    }

    protected abstract Supplier<T> initBeanCreator(Class<T> var1);

    protected abstract ISetterCaller<T> initBeanSetter(String var1);

    public Supplier<T> getBeanCreator() {
        return this.supplier;
    }

    public ISetterCaller<T> getBeanSetter(String fieldName) {
        ISetterCaller<T> setterCaller = this.setters.get(fieldName);
        if (setterCaller == null) {
            setterCaller = this.initBeanSetter(fieldName);
            this.setters.put(fieldName, setterCaller);
        }
        return setterCaller;
    }
}

