/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.api;

import io.github.kiryu1223.expressionTree.delegate.Action1;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.data.sqlink.api.crud.read.LQuery;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;

public class Filter {
    private final Map<Class<?>, Map<String, Action1<LQuery<?>>>> onSelect = new LinkedHashMap();

    public <T> void onSelect(String filterId, Class<T> targetType, Action1<LQuery<T>> action) {
        Map actionMap = this.onSelect.computeIfAbsent(targetType, k -> new LinkedHashMap());
        actionMap.put(filterId, ExpressionUtil.cast(action));
    }

    public <T> void invokeOnSelect(Class<T> targetType, LQuery<T> query, List<String> ignoreFilterIds, boolean isIgnoreFilterAll) {
        if (isIgnoreFilterAll) {
            return;
        }
        for (Map.Entry<Class<?>, Map<String, Action1<LQuery<?>>>> entry : this.onSelect.entrySet()) {
            Class<T> key = entry.getKey();
            if (!key.isAssignableFrom(targetType)) continue;
            Map<String, Action1<LQuery<?>>> value = entry.getValue();
            value.forEach((k, v) -> {
                if (ignoreFilterIds.isEmpty() || !ignoreFilterIds.contains(k)) {
                    v.invoke((Object)query);
                }
            });
        }
    }
}

