/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression.impl;

import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.SqLinkDialect;
import org.noear.solon.data.sqlink.base.expression.AsName;
import org.noear.solon.data.sqlink.base.expression.ISqlDynamicColumnExpression;
import org.noear.solon.data.sqlink.base.session.SqlValue;

public class SqlDynamicColumnExpression
implements ISqlDynamicColumnExpression {
    private final String column;
    private AsName tableAsName;

    public SqlDynamicColumnExpression(String column, AsName tableAsName) {
        this.column = column;
        this.tableAsName = tableAsName;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public AsName getTableAsName() {
        return this.tableAsName;
    }

    @Override
    public void setTableAsName(AsName tableAsName) {
        this.tableAsName = tableAsName;
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> values) {
        SqLinkDialect dialect = config.getDisambiguation();
        String columnName = dialect.disambiguation(this.column);
        if (this.tableAsName != null) {
            return dialect.disambiguation(this.tableAsName.getName()) + "." + columnName;
        }
        return columnName;
    }
}

