/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlBuilder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlGroupByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSelectExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTableExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.base.toBean.Include.IncludeSet;
import org.noear.solon.data.sqlink.core.sqlBuilder.ISqlBuilder;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;

public class QuerySqlBuilder
implements ISqlBuilder {
    private final SqLinkConfig config;
    private ISqlQueryableExpression queryable;
    private final List<IncludeSet> includeSets = new ArrayList<IncludeSet>();

    public QuerySqlBuilder(SqLinkConfig config, ISqlQueryableExpression queryable) {
        this.config = config;
        this.queryable = queryable;
    }

    public void addWhere(ISqlExpression cond) {
        this.queryable.addWhere(cond);
    }

    public void addOrWhere(ISqlExpression cond) {
        if (this.queryable.getWhere().isEmpty()) {
            this.addWhere(cond);
        } else {
            SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
            this.addWhere(factory.unary(SqlOperator.OR, cond));
        }
    }

    public void addJoin(JoinType joinType, ISqlTableExpression table, ISqlExpression conditions) {
        SqlExpressionFactory factory = this.config.getSqlExpressionFactory();
        String asName = ExpressionUtil.getAsName(table.getMainTableClass());
        asName = this.doGetAsName(asName);
        ISqlJoinExpression join = factory.join(joinType, table, conditions, asName);
        this.queryable.addJoin(join);
    }

    private String doGetAsName(String as) {
        HashSet<String> asNames = new HashSet<String>();
        String asName = this.queryable.getFrom().getAsName();
        asNames.add(asName);
        this.queryable.getJoins().getJoins().forEach(join -> asNames.add(join.getAsName()));
        return this.doGetAsName(asNames, as, 0);
    }

    private String doGetAsName(Set<String> asNameSet, String as, int offset) {
        String next;
        String string = next = offset == 0 ? as : as + offset;
        if (asNameSet.contains(next)) {
            return this.doGetAsName(asNameSet, as, offset + 1);
        }
        return next;
    }

    public void setGroup(ISqlGroupByExpression group) {
        SqlExpressionFactory factory = this.config.getSqlExpressionFactory();
        this.queryable.setGroup(group);
    }

    public void addHaving(ISqlExpression cond) {
        this.queryable.addHaving(cond);
    }

    public void addOrder(ISqlOrderExpression order) {
        this.queryable.addOrder(order);
    }

    public void setSelect(ISqlSelectExpression select) {
        this.queryable.setSelect(select);
    }

    public void setSelect(Class<?> c) {
        List<Class<?>> orderedClass = this.getOrderedClass();
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        MetaData metaData = MetaDataCache.getMetaData(c);
        ArrayList<ISqlExpression> expressions = new ArrayList<ISqlExpression>();
        if (orderedClass.contains(c)) {
            String as = metaData.getTableName().substring(0, 1).toLowerCase();
            for (FieldMetaData notIgnoreProperty : metaData.getNotIgnorePropertys()) {
                expressions.add(factory.column(notIgnoreProperty, as));
            }
        } else {
            block1: for (FieldMetaData sel : metaData.getNotIgnorePropertys()) {
                for (MetaData data : MetaDataCache.getMetaData(this.getOrderedClass())) {
                    String as = ExpressionUtil.getAsName(data.getType());
                    for (FieldMetaData noi : data.getNotIgnorePropertys()) {
                        if (!noi.getColumn().equals(sel.getColumn()) || !noi.getType().equals(sel.getType())) continue;
                        expressions.add(factory.column(sel, as));
                        continue block1;
                    }
                }
            }
        }
        this.queryable.setSelect(factory.select(expressions, c));
    }

    public void setLimit(long offset, long rows) {
        this.queryable.setLimit(offset, rows);
    }

    public void setDistinct(boolean distinct) {
        this.queryable.setDistinct(distinct);
    }

    @Override
    public SqLinkConfig getConfig() {
        return this.config;
    }

    @Override
    public String getSql() {
        return this.queryable.getSql(this.config);
    }

    @Override
    public String getSqlAndValue(List<SqlValue> values) {
        return this.queryable.getSqlAndValue(this.config, values);
    }

    public List<Class<?>> getOrderedClass() {
        return this.queryable.getOrderedClass();
    }

    public List<FieldMetaData> getMappingData() {
        return this.queryable.getMappingData();
    }

    public boolean isSingle() {
        return this.queryable.getSelect().isSingle();
    }

    public <T> Class<T> getTargetClass() {
        return this.queryable.getMainTableClass();
    }

    public ISqlQueryableExpression getQueryable() {
        return this.queryable;
    }

    public void setQueryable(ISqlQueryableExpression queryable) {
        this.queryable = queryable;
    }

    public List<IncludeSet> getIncludeSets() {
        return this.includeSets;
    }

    public IncludeSet getLastIncludeSet() {
        return this.includeSets.get(this.includeSets.size() - 1);
    }
}

