/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.api.crud.update;

import io.github.kiryu1223.expressionTree.expressions.ExprTree;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import java.util.ArrayList;
import org.noear.solon.data.sqlink.api.crud.CRUD;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlRealTableExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.core.exception.SqLinkException;
import org.noear.solon.data.sqlink.core.sqlBuilder.UpdateSqlBuilder;
import org.noear.solon.data.sqlink.core.visitor.SqlVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateBase
extends CRUD {
    public static final Logger log = LoggerFactory.getLogger(UpdateBase.class);
    private final UpdateSqlBuilder sqlBuilder;

    public UpdateBase(UpdateSqlBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    protected UpdateSqlBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    @Override
    protected SqLinkConfig getConfig() {
        return this.sqlBuilder.getConfig();
    }

    @Override
    public String toSql() {
        return this.sqlBuilder.getSql();
    }

    public long executeRows() {
        this.checkHasSet();
        this.checkHasWhere();
        SqLinkConfig config = this.getConfig();
        ArrayList<SqlValue> sqlValues = new ArrayList<SqlValue>();
        String sql = this.sqlBuilder.getSqlAndValue(sqlValues);
        this.tryPrintSql(log, sql);
        SqlSession session = config.getSqlSessionFactory().getSession(config);
        return session.executeUpdate(sql, sqlValues);
    }

    private void checkHasSet() {
        if (!this.sqlBuilder.hasSet()) {
            throw new SqLinkException("SET\u4e3a\u7a7a");
        }
    }

    private void checkHasWhere() {
        if (this.getConfig().isIgnoreUpdateNoWhere()) {
            return;
        }
        if (!this.sqlBuilder.hasWhere()) {
            throw new SqLinkException("UPDATE\u6ca1\u6709\u6761\u4ef6");
        }
    }

    protected void join(JoinType joinType, Class<?> target, ExprTree<?> expr) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig());
        Object on = sqlVisitor.visit(expr.getTree());
        ISqlRealTableExpression table = factory.table(target);
        this.getSqlBuilder().addJoin(joinType, table, (ISqlExpression)on);
    }

    protected void set(LambdaExpression<?> left, Object value) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig());
        ISqlColumnExpression column = sqlVisitor.toColumn(left);
        this.sqlBuilder.addSet(factory.set(column, factory.AnyValue(value)));
    }

    protected void set(LambdaExpression<?> left, LambdaExpression<?> right) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig());
        ISqlColumnExpression column = sqlVisitor.toColumn(left);
        Object value = sqlVisitor.visit((LambdaExpression)right);
        this.sqlBuilder.addSet(factory.set(column, (ISqlExpression)value));
    }

    protected void where(LambdaExpression<?> lambda) {
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig());
        Object expression = sqlVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addWhere((ISqlExpression)expression);
    }
}

