/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.visitor.methods;

import java.util.Arrays;
import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;

public class LogicExpression {
    public static ISqlExpression IfExpression(SqLinkConfig config, ISqlExpression cond, ISqlExpression truePart, ISqlExpression falsePart) {
        List<String> function;
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        List<ISqlExpression> args = Arrays.asList(cond, truePart, falsePart);
        switch (config.getDbType()) {
            case SQLServer: 
            case SQLite: {
                function = Arrays.asList("IIF(", ",", ",", ")");
                break;
            }
            case Oracle: 
            case PostgreSQL: {
                function = Arrays.asList("(CASE WHEN ", " THEN ", " ELSE ", " END)");
                break;
            }
            default: {
                function = Arrays.asList("IF(", ",", ",", ")");
            }
        }
        return factory.template(function, args);
    }

    public static ISqlExpression notNullExpression(SqLinkConfig config, ISqlExpression expression) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        return factory.binary(SqlOperator.IS, expression, factory.unary(SqlOperator.NOT, factory.AnyValue(null)));
    }
}

