/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlBuilder;

import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlUpdateExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.core.sqlBuilder.ISqlBuilder;

public class UpdateSqlBuilder
implements ISqlBuilder {
    private final SqLinkConfig config;
    private final SqlExpressionFactory factory;
    private final ISqlUpdateExpression update;

    public UpdateSqlBuilder(SqLinkConfig config, ISqlUpdateExpression update) {
        this.config = config;
        this.update = update;
        this.factory = config.getSqlExpressionFactory();
    }

    public void addJoin(JoinType joinType, ISqlTableExpression table, ISqlExpression on) {
        String as = MetaDataCache.getMetaData(table.getMainTableClass()).getTableName().substring(0, 1).toLowerCase();
        ISqlJoinExpression join = this.factory.join(joinType, table, on, as);
        this.update.addJoin(join);
    }

    public void addSet(ISqlSetExpression set) {
        this.update.addSet(set);
    }

    public void addWhere(ISqlExpression where) {
        this.update.addWhere(where);
    }

    public boolean hasWhere() {
        return !this.update.getWhere().isEmpty();
    }

    @Override
    public String getSql() {
        return this.getSqlAndValue(null);
    }

    @Override
    public String getSqlAndValue(List<SqlValue> sqlValues) {
        return this.update.getSqlAndValue(this.config, sqlValues);
    }

    @Override
    public SqLinkConfig getConfig() {
        return this.config;
    }
}

