/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.expression.oracle;

import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.SqLinkDialect;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlRealTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWithExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.impl.SqlJoinExpression;
import org.noear.solon.data.sqlink.base.session.SqlValue;

public class OracleJoinExpression
extends SqlJoinExpression {
    protected OracleJoinExpression(JoinType joinType, ISqlTableExpression joinTable, ISqlExpression conditions, String asName) {
        super(joinType, joinTable, conditions, asName);
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> values) {
        StringBuilder builder = new StringBuilder();
        SqLinkDialect disambiguation = config.getDisambiguation();
        builder.append(this.joinType.getJoin()).append(" ");
        if (this.joinTable instanceof ISqlRealTableExpression) {
            builder.append(this.joinTable.getSqlAndValue(config, values));
        } else if (this.joinTable instanceof ISqlWithExpression) {
            ISqlWithExpression table = (ISqlWithExpression)this.joinTable;
            builder.append(disambiguation.disambiguationTableName(table.withTableName()));
        } else {
            builder.append("(").append(this.joinTable.getSqlAndValue(config, values)).append(")");
        }
        if (this.getAsName() != null) {
            builder.append(" ").append(disambiguation.disambiguation(this.getAsName())).append(" ");
        }
        builder.append(" ON ");
        builder.append(this.conditions.getSqlAndValue(config, values));
        return builder.toString();
    }
}

