/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlBinaryExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlCollectedValueExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSingleValueExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTemplateExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlValueExpression;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.core.visitor.methods.StringMethods;

public class SqlBinaryExpression
implements ISqlBinaryExpression {
    private final SqlOperator operator;
    private final ISqlExpression left;
    private final ISqlExpression right;

    public SqlBinaryExpression(SqlOperator operator, ISqlExpression left, ISqlExpression right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public SqlOperator getOperator() {
        return this.operator;
    }

    @Override
    public ISqlExpression getLeft() {
        return this.left;
    }

    @Override
    public ISqlExpression getRight() {
        return this.right;
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> sqlValues) {
        SqlOperator operator = this.getOperator();
        StringBuilder sb = new StringBuilder();
        if (this.getLeft() instanceof ISqlColumnExpression && this.getRight() instanceof ISqlValueExpression) {
            ISqlColumnExpression sqlColumn = (ISqlColumnExpression)this.getLeft();
            ISqlValueExpression valueExpression = (ISqlValueExpression)this.getRight();
            FieldMetaData fieldMetaData = sqlColumn.getFieldMetaData();
            if (operator == SqlOperator.PLUS && fieldMetaData.getType() == String.class && valueExpression instanceof ISqlSingleValueExpression && valueExpression.nouNull() && ((ISqlSingleValueExpression)valueExpression).getValue() instanceof String) {
                ISqlTemplateExpression concat = StringMethods.concat(config, sqlColumn, valueExpression);
                sb.append(concat.getSqlAndValue(config, sqlValues));
                return sb.toString();
            }
            sb.append(sqlColumn.getSqlAndValue(config, sqlValues));
            sb.append(" ");
            if (operator == SqlOperator.EQ && !valueExpression.nouNull()) {
                sb.append(SqlOperator.IS.getOperator());
            } else {
                sb.append(operator.getOperator());
            }
            sb.append(" ");
            if (valueExpression instanceof ISqlSingleValueExpression) {
                ISqlSingleValueExpression singleValue = (ISqlSingleValueExpression)valueExpression;
                if (sqlValues != null) {
                    sqlValues.add(new SqlValue(singleValue.getValue(), fieldMetaData.getTypeHandler(), fieldMetaData.getOnPut()));
                }
                sb.append("?");
            } else {
                ISqlCollectedValueExpression collectedValue = (ISqlCollectedValueExpression)valueExpression;
                if (operator == SqlOperator.IN) {
                    Collection<?> collection = collectedValue.getCollection();
                    sb.append("(");
                    ArrayList<String> strings = new ArrayList<String>(collection.size());
                    for (Object o : collection) {
                        if (sqlValues != null) {
                            sqlValues.add(new SqlValue(o, fieldMetaData.getTypeHandler(), fieldMetaData.getOnPut()));
                        }
                        strings.add("?");
                    }
                    sb.append(String.join((CharSequence)collectedValue.getDelimiter(), strings));
                    sb.append(")");
                } else {
                    if (sqlValues != null) {
                        sqlValues.add(new SqlValue(collectedValue.getCollection(), fieldMetaData.getTypeHandler(), fieldMetaData.getOnPut()));
                    }
                    sb.append("?");
                }
            }
        } else if (this.getRight() instanceof ISqlColumnExpression && this.getLeft() instanceof ISqlValueExpression) {
            ISqlColumnExpression sqlColumn = (ISqlColumnExpression)this.getRight();
            ISqlValueExpression valueExpression = (ISqlValueExpression)this.getLeft();
            FieldMetaData fieldMetaData = sqlColumn.getFieldMetaData();
            if (operator == SqlOperator.PLUS && fieldMetaData.getType() == String.class && valueExpression instanceof ISqlSingleValueExpression && valueExpression.nouNull() && ((ISqlSingleValueExpression)valueExpression).getValue() instanceof String) {
                ISqlTemplateExpression concat = StringMethods.concat(config, valueExpression, sqlColumn);
                sb.append(concat.getSqlAndValue(config, sqlValues));
                return sb.toString();
            }
            if (valueExpression instanceof ISqlSingleValueExpression) {
                ISqlSingleValueExpression singleValue = (ISqlSingleValueExpression)valueExpression;
                if (sqlValues != null) {
                    sqlValues.add(new SqlValue(singleValue.getValue(), fieldMetaData.getTypeHandler(), fieldMetaData.getOnPut()));
                }
                sb.append("?");
            } else {
                ISqlCollectedValueExpression collectedValue = (ISqlCollectedValueExpression)valueExpression;
                if (operator == SqlOperator.IN) {
                    Collection<?> collection = collectedValue.getCollection();
                    sb.append("(");
                    ArrayList<String> strings = new ArrayList<String>(collection.size());
                    for (Object o : collection) {
                        if (sqlValues != null) {
                            sqlValues.add(new SqlValue(o, fieldMetaData.getTypeHandler(), fieldMetaData.getOnPut()));
                        }
                        strings.add("?");
                    }
                    sb.append(String.join((CharSequence)collectedValue.getDelimiter(), strings));
                    sb.append(")");
                } else {
                    if (sqlValues != null) {
                        sqlValues.add(new SqlValue(collectedValue.getCollection(), fieldMetaData.getTypeHandler(), fieldMetaData.getOnPut()));
                    }
                    sb.append("?");
                }
            }
            sb.append("?");
            sb.append(" ");
            if (operator == SqlOperator.EQ && !valueExpression.nouNull()) {
                sb.append(SqlOperator.IS.getOperator());
            } else {
                sb.append(operator.getOperator());
            }
            sb.append(" ");
            sb.append(sqlColumn.getSqlAndValue(config, sqlValues));
        } else if (operator == SqlOperator.PLUS && (this.getLeft() instanceof ISqlSingleValueExpression && ((ISqlSingleValueExpression)this.getLeft()).getValue() instanceof String || this.getLeft() instanceof ISqlColumnExpression && ((ISqlColumnExpression)this.getLeft()).getFieldMetaData().getType() == String.class || this.getRight() instanceof ISqlSingleValueExpression && ((ISqlSingleValueExpression)this.getRight()).getValue() instanceof String || this.getRight() instanceof ISqlColumnExpression && ((ISqlColumnExpression)this.getRight()).getFieldMetaData().getType() == String.class)) {
            ISqlTemplateExpression concat = StringMethods.concat(config, this.getLeft(), this.getRight());
            sb.append(concat.getSqlAndValue(config, sqlValues));
        } else {
            sb.append(this.getLeft().getSqlAndValue(config, sqlValues));
            sb.append(" ");
            if (operator == SqlOperator.EQ && this.getRight() instanceof ISqlSingleValueExpression && !((ISqlSingleValueExpression)this.getRight()).nouNull()) {
                sb.append(SqlOperator.IS.getOperator());
            } else {
                sb.append(operator.getOperator());
            }
            sb.append(" ");
            if (operator == SqlOperator.IN) {
                sb.append("(");
                sb.append(this.getRight().getSqlAndValue(config, sqlValues));
                sb.append(")");
            } else {
                sb.append(this.getRight().getSqlAndValue(config, sqlValues));
            }
        }
        return sb.toString();
    }
}

