/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.api.crud.read;

import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.noear.solon.data.sqlink.annotation.RelationType;
import org.noear.solon.data.sqlink.api.crud.CRUD;
import org.noear.solon.data.sqlink.api.crud.read.EndQuery;
import org.noear.solon.data.sqlink.api.crud.read.LQuery;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlGroupByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSelectExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTemplateExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.metaData.IMappingTable;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.metaData.NavigateData;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.base.toBean.Include.IncludeFactory;
import org.noear.solon.data.sqlink.base.toBean.Include.IncludeSet;
import org.noear.solon.data.sqlink.base.toBean.build.ObjectBuilder;
import org.noear.solon.data.sqlink.core.exception.SqLinkException;
import org.noear.solon.data.sqlink.core.page.PagedResult;
import org.noear.solon.data.sqlink.core.page.Pager;
import org.noear.solon.data.sqlink.core.sqlBuilder.QuerySqlBuilder;
import org.noear.solon.data.sqlink.core.visitor.SqlVisitor;
import org.noear.solon.data.sqlink.core.visitor.methods.AggregateMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryBase
extends CRUD {
    public static final Logger log = LoggerFactory.getLogger(QueryBase.class);
    private final QuerySqlBuilder sqlBuilder;

    public QueryBase(QuerySqlBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    protected QuerySqlBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    @Override
    protected SqLinkConfig getConfig() {
        return this.sqlBuilder.getConfig();
    }

    protected boolean any0(LambdaExpression<?> lambda) {
        SqLinkConfig config = this.getConfig();
        ISqlQueryableExpression queryableCopy = this.getSqlBuilder().getQueryable().copy(config);
        QuerySqlBuilder querySqlBuilder = new QuerySqlBuilder(config, queryableCopy);
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        querySqlBuilder.setSelect(factory.select(Collections.singletonList(factory.constString("1")), Integer.TYPE));
        querySqlBuilder.setLimit(0L, 1L);
        if (lambda != null) {
            SqlVisitor sqlVisitor = new SqlVisitor(config, queryableCopy);
            Object cond = sqlVisitor.visit((LambdaExpression)lambda);
            querySqlBuilder.addWhere((ISqlExpression)cond);
        }
        SqlSession session = this.getConfig().getSqlSessionFactory().getSession(config);
        ArrayList<SqlValue> values = new ArrayList<SqlValue>();
        String sql = querySqlBuilder.getSqlAndValue(values);
        this.tryPrintSql(log, sql);
        return session.executeQuery(ResultSet::next, sql, values);
    }

    protected <T> List<T> toList() {
        SqLinkConfig config = this.getConfig();
        boolean single = this.sqlBuilder.isSingle();
        List mappingData = single ? Collections.emptyList() : this.sqlBuilder.getMappingData();
        ArrayList<SqlValue> values = new ArrayList<SqlValue>();
        String sql = this.sqlBuilder.getSqlAndValue(values);
        this.tryPrintSql(log, sql);
        Class<?> targetClass = this.sqlBuilder.getTargetClass();
        SqlSession session = config.getSqlSessionFactory().getSession(config);
        List ts = session.executeQuery(r -> ObjectBuilder.start(r, targetClass, mappingData, single, config).createList(), sql, values);
        if (!this.sqlBuilder.getIncludeSets().isEmpty()) {
            try {
                IncludeFactory includeFactory = config.getIncludeFactory();
                includeFactory.getBuilder(this.getConfig(), session, targetClass, ts, this.sqlBuilder.getIncludeSets(), this.sqlBuilder.getQueryable()).include();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return ts;
    }

    protected <T> T first() {
        ISqlQueryableExpression queryableCopy = this.getSqlBuilder().getQueryable().copy(this.getConfig());
        QuerySqlBuilder querySqlBuilder = new QuerySqlBuilder(this.getConfig(), queryableCopy);
        querySqlBuilder.getIncludeSets().addAll(this.getSqlBuilder().getIncludeSets());
        LQuery lQuery = new LQuery(querySqlBuilder);
        lQuery.limit(1L);
        List list = lQuery.toList();
        return list.isEmpty() ? null : (T)list.get(0);
    }

    protected void distinct0(boolean condition) {
        this.sqlBuilder.setDistinct(condition);
    }

    protected <R> EndQuery<R> select(Class<R> r) {
        this.select0(r);
        return new EndQuery(this.boxedQuerySqlBuilder());
    }

    protected boolean select(LambdaExpression<?> lambda) {
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        ISqlSelectExpression select = sqlVisitor.toSelect(lambda);
        this.sqlBuilder.setSelect(select);
        return this.sqlBuilder.isSingle();
    }

    protected void select0(Class<?> c) {
        this.sqlBuilder.setSelect(c);
    }

    protected void join(JoinType joinType, Class<?> target, LambdaExpression<?> lambda) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        Object on = sqlVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addJoin(joinType, factory.table(target), (ISqlExpression)on);
    }

    protected void join(JoinType joinType, QueryBase target, LambdaExpression<?> lambda) {
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        Object on = sqlVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addJoin(joinType, target.getSqlBuilder().getQueryable(), (ISqlExpression)on);
    }

    protected void where(LambdaExpression<?> lambda) {
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        Object where = sqlVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addWhere((ISqlExpression)where);
    }

    protected void orWhere(LambdaExpression<?> lambda) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        Object where = sqlVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addOrWhere((ISqlExpression)where);
    }

    protected void groupBy(LambdaExpression<?> lambda) {
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        ISqlGroupByExpression group = sqlVisitor.toGroup(lambda);
        this.sqlBuilder.setGroup(group);
    }

    protected void having(LambdaExpression<?> lambda) {
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        Object expression = sqlVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addHaving((ISqlExpression)expression);
    }

    protected void orderBy(LambdaExpression<?> lambda, boolean asc) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        Object expression = sqlVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addOrder(factory.order((ISqlExpression)expression, asc));
    }

    protected void limit0(long rows) {
        this.limit0(0L, rows);
    }

    protected void limit0(long offset, long rows) {
        this.sqlBuilder.setLimit(offset, rows);
    }

    protected void singleCheck(boolean single) {
        if (single) {
            throw new RuntimeException("query.select(Func<T1,T2..., R> expr) \u4e0d\u5141\u8bb8\u4f20\u5165\u5355\u4e2a\u5143\u7d20, \u5355\u5143\u7d20\u8bf7\u4f7f\u7528endSelect");
        }
    }

    @Override
    public String toSql() {
        return this.sqlBuilder.getSql();
    }

    protected QuerySqlBuilder boxedQuerySqlBuilder() {
        ISqlQueryableExpression queryable = this.sqlBuilder.getQueryable();
        Class<?> mainTableClass = queryable.getMainTableClass();
        String as = MetaDataCache.getMetaData(mainTableClass).getTableName().substring(0, 1).toLowerCase();
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        return new QuerySqlBuilder(this.getConfig(), factory.queryable(factory.from(queryable, as)));
    }

    protected void include(LambdaExpression<?> lambda, ISqlExpression cond, List<IncludeSet> includeSets) {
        IncludeSet includeSet;
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        ISqlColumnExpression columnExpression = sqlVisitor.toColumn(lambda);
        if (!columnExpression.getFieldMetaData().hasNavigate()) {
            throw new RuntimeException("include\u6307\u5b9a\u7684\u5b57\u6bb5\u9700\u8981\u88ab@Navigate\u4fee\u9970");
        }
        this.relationTypeCheck(columnExpression.getFieldMetaData().getNavigateData());
        if (cond != null) {
            SqlVisitor coVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
            includeSet = new IncludeSet(columnExpression, cond);
        } else {
            includeSet = new IncludeSet(columnExpression);
        }
        includeSets.add(includeSet);
    }

    protected void include(LambdaExpression<?> lambda, ISqlExpression cond) {
        this.include(lambda, cond, this.sqlBuilder.getIncludeSets());
    }

    protected void include(LambdaExpression<?> lambda) {
        this.include(lambda, null, this.sqlBuilder.getIncludeSets());
    }

    protected void relationTypeCheck(NavigateData navigateData) {
        RelationType relationType = navigateData.getRelationType();
        switch (relationType) {
            case OneToOne: 
            case ManyToOne: {
                if (!navigateData.isCollectionWrapper()) break;
                throw new SqLinkException((Object)((Object)relationType) + "\u4e0d\u652f\u6301\u96c6\u5408");
            }
            case OneToMany: {
                if (navigateData.isCollectionWrapper()) break;
                if (!List.class.isAssignableFrom(navigateData.getCollectionWrapperType()) && !Set.class.isAssignableFrom(navigateData.getCollectionWrapperType())) {
                    throw new SqLinkException((Object)((Object)relationType) + "\u53ea\u652f\u6301List\u548cSet");
                }
                throw new SqLinkException((Object)((Object)relationType) + "\u53ea\u652f\u6301\u96c6\u5408");
            }
            case ManyToMany: {
                if (navigateData.getMappingTableType() == IMappingTable.class || navigateData.getSelfMappingFieldName().isEmpty() || navigateData.getTargetMappingFieldName().isEmpty()) {
                    throw new SqLinkException((Object)((Object)relationType) + "\u4e0b@Navigate\u6ce8\u89e3\u7684midTable\u548cSelfMapping\u548cTargetMapping\u5b57\u6bb5\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (navigateData.isCollectionWrapper()) break;
                if (!List.class.isAssignableFrom(navigateData.getCollectionWrapperType()) && !Set.class.isAssignableFrom(navigateData.getCollectionWrapperType())) {
                    throw new SqLinkException((Object)((Object)relationType) + "\u53ea\u652f\u6301List\u548cSet");
                }
                throw new RuntimeException((Object)((Object)relationType) + "\u53ea\u652f\u6301\u96c6\u5408");
            }
        }
    }

    protected <T> PagedResult<T> toPagedResult0(long pageIndex, long pageSize, Pager pager) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        QuerySqlBuilder boxedQuerySqlBuilder = this.boxedQuerySqlBuilder();
        boxedQuerySqlBuilder.setSelect(factory.select(Collections.singletonList(AggregateMethods.count(this.getConfig(), null)), Long.TYPE, true, false));
        LQuery countQuery = new LQuery(boxedQuerySqlBuilder);
        long total = (Long)countQuery.toList().get(0);
        QuerySqlBuilder dataQuerySqlBuilder = new QuerySqlBuilder(this.getConfig(), this.getSqlBuilder().getQueryable().copy(this.getConfig()));
        dataQuerySqlBuilder.getIncludeSets().addAll(dataQuerySqlBuilder.getIncludeSets());
        LQuery dataQuery = new LQuery(dataQuerySqlBuilder);
        long take = Math.max(pageSize, 1L);
        long index = Math.max(pageIndex, 1L);
        long offset = (index - 1L) * take;
        List list = dataQuery.limit(offset, take).toList();
        return pager.getPagedResult(total, list);
    }

    protected long count0(LambdaExpression<?> lambda) {
        List<ISqlExpression> countList;
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        if (lambda == null) {
            ISqlTemplateExpression count = AggregateMethods.count(this.getConfig());
            countList = Collections.singletonList(count);
        } else {
            SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
            ISqlTemplateExpression count = AggregateMethods.count(this.getConfig(), (ISqlExpression)sqlVisitor.visit((LambdaExpression)lambda));
            countList = Collections.singletonList(count);
        }
        ISqlQueryableExpression copy = this.sqlBuilder.getQueryable().copy(this.getConfig());
        QuerySqlBuilder copyQuerySqlBuilder = new QuerySqlBuilder(this.getConfig(), copy);
        copyQuerySqlBuilder.setSelect(factory.select(countList, Long.TYPE, true, false));
        LQuery countQuery = new LQuery(copyQuerySqlBuilder);
        return (Long)countQuery.toList().get(0);
    }

    protected List<Long> groupByCount0(LambdaExpression<?> lambda) {
        List<ISqlExpression> countList;
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        if (lambda == null) {
            ISqlTemplateExpression count = AggregateMethods.count(this.getConfig());
            countList = Collections.singletonList(count);
        } else {
            SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
            ISqlTemplateExpression count = AggregateMethods.count(this.getConfig(), (ISqlExpression)sqlVisitor.visit((LambdaExpression)lambda));
            countList = Collections.singletonList(count);
        }
        ISqlQueryableExpression copy = this.sqlBuilder.getQueryable().copy(this.getConfig());
        QuerySqlBuilder copyQuerySqlBuilder = new QuerySqlBuilder(this.getConfig(), copy);
        copyQuerySqlBuilder.setSelect(factory.select(countList, Long.TYPE, true, false));
        LQuery countQuery = new LQuery(copyQuerySqlBuilder);
        return countQuery.toList();
    }

    protected <T extends Number> T sum0(LambdaExpression<?> lambda) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        ISqlTemplateExpression sum = AggregateMethods.sum(this.getConfig(), (ISqlExpression)sqlVisitor.visit((LambdaExpression)lambda));
        List<ISqlExpression> sumList = Collections.singletonList(sum);
        ISqlQueryableExpression copy = this.sqlBuilder.getQueryable().copy(this.getConfig());
        QuerySqlBuilder copyQuerySqlBuilder = new QuerySqlBuilder(this.getConfig(), copy);
        copyQuerySqlBuilder.setSelect(factory.select(sumList, lambda.getReturnType(), true, false));
        LQuery sumQuery = new LQuery(copyQuerySqlBuilder);
        return (T)((Number)sumQuery.toList().get(0));
    }

    protected <T extends Number> List<T> groupBySum0(LambdaExpression<?> lambda) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        ISqlTemplateExpression sum = AggregateMethods.sum(this.getConfig(), (ISqlExpression)sqlVisitor.visit((LambdaExpression)lambda));
        List<ISqlExpression> sumList = Collections.singletonList(sum);
        ISqlQueryableExpression copy = this.sqlBuilder.getQueryable().copy(this.getConfig());
        QuerySqlBuilder copyQuerySqlBuilder = new QuerySqlBuilder(this.getConfig(), copy);
        copyQuerySqlBuilder.setSelect(factory.select(sumList, lambda.getReturnType(), true, false));
        LQuery sumQuery = new LQuery(copyQuerySqlBuilder);
        return sumQuery.toList();
    }

    protected BigDecimal avg0(LambdaExpression<?> lambda) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        ISqlTemplateExpression avg = AggregateMethods.avg(this.getConfig(), (ISqlExpression)sqlVisitor.visit((LambdaExpression)lambda));
        List<ISqlExpression> avgList = Collections.singletonList(avg);
        ISqlQueryableExpression copy = this.sqlBuilder.getQueryable().copy(this.getConfig());
        QuerySqlBuilder avgQuerySqlBuilder = new QuerySqlBuilder(this.getConfig(), copy);
        avgQuerySqlBuilder.setSelect(factory.select(avgList, BigDecimal.class, true, false));
        LQuery avgQuery = new LQuery(avgQuerySqlBuilder);
        return (BigDecimal)avgQuery.toList().get(0);
    }

    protected List<BigDecimal> groupByAvg0(LambdaExpression<?> lambda) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        ISqlTemplateExpression avg = AggregateMethods.avg(this.getConfig(), (ISqlExpression)sqlVisitor.visit((LambdaExpression)lambda));
        List<ISqlExpression> avgList = Collections.singletonList(avg);
        ISqlQueryableExpression copy = this.sqlBuilder.getQueryable().copy(this.getConfig());
        QuerySqlBuilder avgQuerySqlBuilder = new QuerySqlBuilder(this.getConfig(), copy);
        avgQuerySqlBuilder.setSelect(factory.select(avgList, BigDecimal.class, true, false));
        LQuery avgQuery = new LQuery(avgQuerySqlBuilder);
        return avgQuery.toList();
    }

    protected <T extends Number> T max0(LambdaExpression<?> lambda) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        ISqlTemplateExpression max = AggregateMethods.max(this.getConfig(), (ISqlExpression)sqlVisitor.visit((LambdaExpression)lambda));
        List<ISqlExpression> maxList = Collections.singletonList(max);
        ISqlQueryableExpression copy = this.sqlBuilder.getQueryable().copy(this.getConfig());
        QuerySqlBuilder maxQuerySqlBuilder = new QuerySqlBuilder(this.getConfig(), copy);
        maxQuerySqlBuilder.setSelect(factory.select(maxList, lambda.getReturnType(), true, false));
        LQuery maxQuery = new LQuery(maxQuerySqlBuilder);
        return (T)((Number)maxQuery.toList().get(0));
    }

    protected <T extends Number> List<T> groupByMax0(LambdaExpression<?> lambda) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        ISqlTemplateExpression max = AggregateMethods.max(this.getConfig(), (ISqlExpression)sqlVisitor.visit((LambdaExpression)lambda));
        List<ISqlExpression> maxList = Collections.singletonList(max);
        ISqlQueryableExpression copy = this.sqlBuilder.getQueryable().copy(this.getConfig());
        QuerySqlBuilder maxQuerySqlBuilder = new QuerySqlBuilder(this.getConfig(), copy);
        maxQuerySqlBuilder.setSelect(factory.select(maxList, lambda.getReturnType(), true, false));
        LQuery maxQuery = new LQuery(maxQuerySqlBuilder);
        return maxQuery.toList();
    }

    protected <T extends Number> T min0(LambdaExpression<?> lambda) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        ISqlTemplateExpression min = AggregateMethods.min(this.getConfig(), (ISqlExpression)sqlVisitor.visit((LambdaExpression)lambda));
        List<ISqlExpression> minList = Collections.singletonList(min);
        ISqlQueryableExpression copy = this.sqlBuilder.getQueryable().copy(this.getConfig());
        QuerySqlBuilder minQuerySqlBuilder = new QuerySqlBuilder(this.getConfig(), copy);
        minQuerySqlBuilder.setSelect(factory.select(minList, lambda.getReturnType(), true, false));
        LQuery minQuery = new LQuery(minQuerySqlBuilder);
        return (T)((Number)minQuery.toList().get(0));
    }

    protected <T extends Number> List<T> groupByMin0(LambdaExpression<?> lambda) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        ISqlTemplateExpression min = AggregateMethods.min(this.getConfig(), (ISqlExpression)sqlVisitor.visit((LambdaExpression)lambda));
        List<ISqlExpression> minList = Collections.singletonList(min);
        ISqlQueryableExpression copy = this.sqlBuilder.getQueryable().copy(this.getConfig());
        QuerySqlBuilder minQuerySqlBuilder = new QuerySqlBuilder(this.getConfig(), copy);
        minQuerySqlBuilder.setSelect(factory.select(minList, lambda.getReturnType(), true, false));
        LQuery minQuery = new LQuery(minQuerySqlBuilder);
        return minQuery.toList();
    }
}

