/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression.impl;

import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.SqLinkDialect;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.session.SqlValue;

public class SqlColumnExpression
implements ISqlColumnExpression {
    private final FieldMetaData fieldMetaData;
    private String tableAsName;

    public SqlColumnExpression(FieldMetaData fieldMetaData, String tableAsName) {
        this.fieldMetaData = fieldMetaData;
        this.tableAsName = tableAsName;
    }

    @Override
    public FieldMetaData getFieldMetaData() {
        return this.fieldMetaData;
    }

    @Override
    public String getTableAsName() {
        return this.tableAsName;
    }

    @Override
    public void setTableAsName(String tableAsName) {
        this.tableAsName = tableAsName;
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> values) {
        SqLinkDialect dialect = config.getDisambiguation();
        String columnName = dialect.disambiguation(this.getFieldMetaData().getColumn());
        if (this.tableAsName != null) {
            return dialect.disambiguation(this.tableAsName) + "." + columnName;
        }
        return columnName;
    }
}

