/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.noear.solon.data.sqlink.base.transaction.Transaction;
import org.noear.solon.data.sqlink.base.transaction.TransactionManager;

public class DefaultTransaction
implements Transaction {
    protected Connection connection;
    protected final DataSource dataSource;
    protected final Integer isolationLevel;
    protected final TransactionManager manager;
    private boolean autoCommit;

    public DefaultTransaction(Integer isolationLevel, DataSource dataSource, TransactionManager manager) {
        this.isolationLevel = isolationLevel;
        this.dataSource = dataSource;
        this.manager = manager;
    }

    @Override
    public Integer getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public void commit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (!this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.clear();
        }
    }

    protected void clear() {
        this.manager.remove();
        try {
            this.connection.setAutoCommit(this.autoCommit);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.dataSource.getConnection();
        }
        this.autoCommit = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        if (this.getIsolationLevel() != null) {
            this.connection.setTransactionIsolation(this.isolationLevel);
        }
        return this.connection;
    }
}

