/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlExt.sqlite;

import java.lang.reflect.Method;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.DbType;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSingleValueExpression;
import org.noear.solon.data.sqlink.base.sqlExt.BaseSqlExtension;
import org.noear.solon.data.sqlink.core.exception.SqLinkIntervalException;

public class SqliteAddOrSubDateExtension
extends BaseSqlExtension {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISqlExpression parse(SqLinkConfig config, Method method, List<ISqlExpression> args) {
        ArrayList<String> templates = new ArrayList<String>();
        ArrayList<ISqlExpression> sqlExpressions = new ArrayList<ISqlExpression>();
        boolean isPlus = method.getName().equals("addDate");
        if (method.getParameterTypes()[0] == LocalDate.class) {
            templates.add("DATE(");
        } else {
            templates.add("DATETIME(");
        }
        sqlExpressions.add(args.get(0));
        if (method.getParameterCount() == 2) {
            ISqlExpression num = args.get(1);
            if (!(num instanceof ISqlSingleValueExpression)) throw new SqLinkIntervalException(DbType.SQLite);
            ISqlSingleValueExpression valueExpression = (ISqlSingleValueExpression)num;
            templates.add(",'" + (isPlus ? "" : "-") + valueExpression.getValue() + " DAY')");
            return config.getSqlExpressionFactory().template(templates, sqlExpressions);
        } else {
            ISqlExpression num = args.get(2);
            if (!(num instanceof ISqlSingleValueExpression)) throw new SqLinkIntervalException(DbType.SQLite);
            ISqlSingleValueExpression valueExpression = (ISqlSingleValueExpression)num;
            templates.add(",'" + (isPlus ? "" : "-") + valueExpression.getValue() + " ");
            sqlExpressions.add(args.get(1));
            templates.add("')");
        }
        return config.getSqlExpressionFactory().template(templates, sqlExpressions);
    }
}

