/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlBuilder;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlGroupByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlRealTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSelectExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTableExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.base.toBean.Include.IncludeSet;
import org.noear.solon.data.sqlink.core.sqlBuilder.ISqlBuilder;

public class QuerySqlBuilder
implements ISqlBuilder {
    private final SqLinkConfig config;
    private final ISqlQueryableExpression queryable;
    private final List<IncludeSet> includeSets = new ArrayList<IncludeSet>();
    private boolean isChanged;

    public QuerySqlBuilder(SqLinkConfig config, ISqlQueryableExpression queryable) {
        this.config = config;
        this.queryable = queryable;
    }

    public void addWhere(ISqlExpression cond) {
        this.queryable.addWhere(cond);
        this.change();
    }

    public void addOrWhere(ISqlExpression cond) {
        if (this.queryable.getWhere().isEmpty()) {
            this.addWhere(cond);
        } else {
            SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
            this.addWhere(factory.unary(SqlOperator.OR, cond));
        }
    }

    public void addJoin(JoinType joinType, ISqlTableExpression table, ISqlExpression conditions) {
        SqlExpressionFactory factory = this.config.getSqlExpressionFactory();
        ISqlJoinExpression join = factory.join(joinType, table, conditions, this.queryable.getOrderedCount());
        this.queryable.addJoin(join);
        this.change();
    }

    public void setGroup(ISqlGroupByExpression group) {
        this.queryable.setGroup(group);
        this.change();
    }

    public void addHaving(ISqlExpression cond) {
        this.queryable.addHaving(cond);
        this.change();
    }

    public void addOrder(ISqlOrderExpression order) {
        this.queryable.addOrder(order);
        this.change();
    }

    public void setSelect(ISqlSelectExpression select) {
        this.queryable.setSelect(select);
        this.change();
    }

    public void addSelectColumn(ISqlExpression expression) {
        this.queryable.addSelectColumn(expression);
        this.change();
    }

    public void setSelect(Class<?> c) {
        List<Class<?>> orderedClass = this.getOrderedClass();
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        MetaData metaData = MetaDataCache.getMetaData(c);
        ArrayList<ISqlExpression> expressions = new ArrayList<ISqlExpression>();
        if (orderedClass.contains(c)) {
            int index = orderedClass.indexOf(c);
            for (FieldMetaData notIgnoreProperty : metaData.getNotIgnorePropertys()) {
                expressions.add(factory.column(notIgnoreProperty, index));
            }
        } else {
            block1: for (FieldMetaData sel : metaData.getNotIgnorePropertys()) {
                int index = 0;
                for (MetaData data : MetaDataCache.getMetaData(this.getOrderedClass())) {
                    for (FieldMetaData noi : data.getNotIgnorePropertys()) {
                        if (!noi.getColumn().equals(sel.getColumn()) || !noi.getType().equals(sel.getType())) continue;
                        expressions.add(factory.column(sel, index));
                        continue block1;
                    }
                    ++index;
                }
            }
        }
        this.queryable.setSelect(factory.select(expressions, c));
        this.change();
    }

    public void setLimit(long offset, long rows) {
        this.queryable.setLimit(offset, rows);
        this.change();
    }

    public void setDistinct(boolean distinct) {
        this.queryable.setDistinct(distinct);
        this.change();
    }

    private void change() {
        this.isChanged = true;
    }

    @Override
    public SqLinkConfig getConfig() {
        return this.config;
    }

    @Override
    public String getSql() {
        if (this.isChanged) {
            return this.queryable.getSql(this.config);
        }
        ISqlTableExpression sqlTableExpression = this.queryable.getFrom().getSqlTableExpression();
        if (sqlTableExpression instanceof ISqlRealTableExpression) {
            return this.queryable.getSql(this.config);
        }
        return sqlTableExpression.getSql(this.config);
    }

    @Override
    public String getSqlAndValue(List<SqlValue> values) {
        if (this.isChanged) {
            return this.queryable.getSqlAndValue(this.config, values);
        }
        ISqlTableExpression sqlTableExpression = this.queryable.getFrom().getSqlTableExpression();
        if (sqlTableExpression instanceof ISqlRealTableExpression) {
            return this.queryable.getSqlAndValue(this.config, values);
        }
        return sqlTableExpression.getSqlAndValue(this.config, values);
    }

    public List<Class<?>> getOrderedClass() {
        return this.queryable.getOrderedClass();
    }

    public List<FieldMetaData> getMappingData() {
        if (this.isChanged) {
            return this.queryable.getMappingData();
        }
        ISqlTableExpression sqlTableExpression = this.queryable.getFrom().getSqlTableExpression();
        if (sqlTableExpression instanceof ISqlRealTableExpression) {
            return this.queryable.getMappingData();
        }
        ISqlQueryableExpression tableExpression = (ISqlQueryableExpression)sqlTableExpression;
        return tableExpression.getMappingData();
    }

    public boolean isSingle() {
        return this.queryable.getSelect().isSingle();
    }

    public Class<?> getTargetClass() {
        return this.queryable.getSelect().getTarget();
    }

    public ISqlQueryableExpression getQueryable() {
        return this.queryable;
    }

    public List<IncludeSet> getIncludeSets() {
        return this.includeSets;
    }

    public IncludeSet getLastIncludeSet() {
        return this.includeSets.get(this.includeSets.size() - 1);
    }
}

