/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression.impl;

import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlCollectedValueExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSingleValueExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlValueExpression;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;

public class SqlSetExpression
implements ISqlSetExpression {
    private final ISqlColumnExpression column;
    private final ISqlExpression value;

    SqlSetExpression(ISqlColumnExpression column, ISqlExpression value) {
        this.column = column;
        this.value = value;
    }

    @Override
    public ISqlColumnExpression getColumn() {
        return this.column;
    }

    @Override
    public ISqlExpression getValue() {
        return this.value;
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> values) {
        String set = this.getColumn().getSqlAndValue(config, values) + " = ";
        FieldMetaData fieldMetaData = this.getColumn().getPropertyMetaData();
        ITypeHandler<?> typeHandler = fieldMetaData.getTypeHandler();
        if (this.getValue() instanceof ISqlValueExpression) {
            if (this.getValue() instanceof ISqlSingleValueExpression) {
                ISqlSingleValueExpression sqlSingleValueExpression = (ISqlSingleValueExpression)this.getValue();
                values.add(new SqlValue(sqlSingleValueExpression.getValue(), typeHandler, fieldMetaData.getOnPut()));
                return set + "?";
            }
            ISqlCollectedValueExpression sqlCollectedValueExpression = (ISqlCollectedValueExpression)this.getValue();
            values.add(new SqlValue(sqlCollectedValueExpression.getCollection(), typeHandler, fieldMetaData.getOnPut()));
            return set + "?";
        }
        return set + this.getValue().getSqlAndValue(config, values);
    }
}

