/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression.impl;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSelectExpression;
import org.noear.solon.data.sqlink.base.session.SqlValue;

public class SqlSelectExpression
implements ISqlSelectExpression {
    protected List<ISqlExpression> columns;
    protected boolean distinct;
    protected Class<?> target;
    protected boolean isSingle;

    SqlSelectExpression(List<ISqlExpression> columns, Class<?> target, boolean isSingle, boolean isDistinct) {
        this.columns = columns;
        this.target = target;
        this.isSingle = isSingle;
        this.distinct = isDistinct;
    }

    @Override
    public List<ISqlExpression> getColumns() {
        return this.columns;
    }

    @Override
    public void setColumns(List<ISqlExpression> columns) {
        this.columns = columns;
    }

    @Override
    public void addColumn(ISqlExpression column) {
        this.columns.add(column);
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public Class<?> getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Class<?> target) {
        this.target = target;
    }

    @Override
    public boolean isSingle() {
        return this.isSingle;
    }

    @Override
    public void setSingle(boolean single) {
        this.isSingle = single;
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> values) {
        ArrayList<String> strings = new ArrayList<String>(this.getColumns().size());
        for (ISqlExpression sqlExpression : this.getColumns()) {
            strings.add(sqlExpression.getSqlAndValue(config, values));
        }
        String col = String.join((CharSequence)",", strings);
        ArrayList<String> result = new ArrayList<String>();
        result.add("SELECT");
        if (this.isDistinct()) {
            result.add("DISTINCT");
        }
        result.add(col);
        return String.join((CharSequence)" ", result);
    }
}

