/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlFromExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlGroupByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlHavingExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlLimitExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSelectExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWhereExpression;
import org.noear.solon.data.sqlink.base.expression.impl.SqlTableExpression;
import org.noear.solon.data.sqlink.base.session.SqlValue;

public class SqlQueryableExpression
extends SqlTableExpression
implements ISqlQueryableExpression {
    protected final ISqlSelectExpression select;
    protected final ISqlFromExpression from;
    protected final ISqlJoinsExpression joins;
    protected final ISqlWhereExpression where;
    protected final ISqlGroupByExpression groupBy;
    protected final ISqlHavingExpression having;
    protected final ISqlOrderByExpression orderBy;
    protected final ISqlLimitExpression limit;

    public SqlQueryableExpression(ISqlSelectExpression select, ISqlFromExpression from, ISqlJoinsExpression joins, ISqlWhereExpression where, ISqlGroupByExpression groupBy, ISqlHavingExpression having, ISqlOrderByExpression orderBy, ISqlLimitExpression limit) {
        this.select = select;
        this.from = from;
        this.joins = joins;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.orderBy = orderBy;
        this.limit = limit;
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> values) {
        String limitSqlAndValue;
        String orderBySqlAndValue;
        String havingSqlAndValue;
        String groupBySqlAndValue;
        String whereSqlAndValue;
        String joinsSqlAndValue;
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(this.getSelect().getSqlAndValue(config, values));
        String fromSqlAndValue = this.getFrom().getSqlAndValue(config, values);
        if (!fromSqlAndValue.isEmpty()) {
            strings.add(fromSqlAndValue);
        }
        if (!(joinsSqlAndValue = this.getJoins().getSqlAndValue(config, values)).isEmpty()) {
            strings.add(joinsSqlAndValue);
        }
        if (!(whereSqlAndValue = this.getWhere().getSqlAndValue(config, values)).isEmpty()) {
            strings.add(whereSqlAndValue);
        }
        if (!(groupBySqlAndValue = this.getGroupBy().getSqlAndValue(config, values)).isEmpty()) {
            strings.add(groupBySqlAndValue);
        }
        if (!(havingSqlAndValue = this.getHaving().getSqlAndValue(config, values)).isEmpty()) {
            strings.add(havingSqlAndValue);
        }
        if (!(orderBySqlAndValue = this.getOrderBy().getSqlAndValue(config, values)).isEmpty()) {
            strings.add(orderBySqlAndValue);
        }
        if (!this.getFrom().isEmptyTable() && !(limitSqlAndValue = this.getLimit().getSqlAndValue(config, values)).isEmpty()) {
            strings.add(limitSqlAndValue);
        }
        return String.join((CharSequence)" ", strings);
    }

    @Override
    public Class<?> getTableClass() {
        return this.select.getTarget();
    }

    @Override
    public void addWhere(ISqlExpression cond) {
        this.where.addCondition(cond);
    }

    @Override
    public void addJoin(ISqlJoinExpression join) {
        this.joins.addJoin(join);
    }

    @Override
    public void setGroup(ISqlGroupByExpression group) {
        this.groupBy.setColumns(group.getColumns());
    }

    @Override
    public void addHaving(ISqlExpression cond) {
        this.having.addCond(cond);
    }

    @Override
    public void addOrder(ISqlOrderExpression order) {
        this.orderBy.addOrder(order);
    }

    @Override
    public void setSelect(ISqlSelectExpression newSelect) {
        this.select.setColumns(newSelect.getColumns());
        this.select.setTarget(newSelect.getTarget());
        this.select.setSingle(newSelect.isSingle());
        this.select.setDistinct(newSelect.isDistinct());
    }

    @Override
    public void addSelectColumn(ISqlExpression expression) {
        this.select.addColumn(expression);
    }

    @Override
    public void setLimit(long offset, long rows) {
        this.limit.setOffset(offset);
        this.limit.setRows(rows);
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.select.setDistinct(distinct);
    }

    @Override
    public ISqlFromExpression getFrom() {
        return this.from;
    }

    @Override
    public int getOrderedCount() {
        return 1 + this.joins.getJoins().size();
    }

    @Override
    public ISqlWhereExpression getWhere() {
        return this.where;
    }

    @Override
    public ISqlGroupByExpression getGroupBy() {
        return this.groupBy;
    }

    @Override
    public ISqlJoinsExpression getJoins() {
        return this.joins;
    }

    @Override
    public ISqlSelectExpression getSelect() {
        return this.select;
    }

    @Override
    public ISqlOrderByExpression getOrderBy() {
        return this.orderBy;
    }

    @Override
    public ISqlLimitExpression getLimit() {
        return this.limit;
    }

    @Override
    public ISqlHavingExpression getHaving() {
        return this.having;
    }

    @Override
    public List<Class<?>> getOrderedClass() {
        Class<?> tableClass = this.getTableClass();
        List<Class<?>> collect = this.joins.getJoins().stream().map(j -> j.getJoinTable().getTableClass()).collect(Collectors.toList());
        collect.add(0, tableClass);
        return collect;
    }
}

