/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression.impl;

import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlBinaryExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSingleValueExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTemplateExpression;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;
import org.noear.solon.data.sqlink.core.visitor.methods.StringMethods;

public class SqlBinaryExpression
implements ISqlBinaryExpression {
    private final SqlOperator operator;
    private final ISqlExpression left;
    private final ISqlExpression right;

    public SqlBinaryExpression(SqlOperator operator, ISqlExpression left, ISqlExpression right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public SqlOperator getOperator() {
        return this.operator;
    }

    @Override
    public ISqlExpression getLeft() {
        return this.left;
    }

    @Override
    public ISqlExpression getRight() {
        return this.right;
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> values) {
        SqlOperator operator = this.getOperator();
        StringBuilder sb = new StringBuilder();
        if (operator == SqlOperator.PLUS && this.getLeft() instanceof ISqlSingleValueExpression && ((ISqlSingleValueExpression)this.getLeft()).getValue() != null && ExpressionUtil.isString(((ISqlSingleValueExpression)this.getLeft()).getType()) || this.getRight() instanceof ISqlSingleValueExpression && ((ISqlSingleValueExpression)this.getRight()).getValue() != null && ExpressionUtil.isString(((ISqlSingleValueExpression)this.getRight()).getType())) {
            ISqlTemplateExpression concat = StringMethods.concat(config, this.getLeft(), this.getRight());
            String sqlAndValue = concat.getSqlAndValue(config, values);
            sb.append(sqlAndValue);
        } else {
            sb.append(this.getLeft().getSqlAndValue(config, values));
            sb.append(" ");
            if (operator == SqlOperator.EQ && this.getRight() instanceof ISqlSingleValueExpression && ((ISqlSingleValueExpression)this.getRight()).getValue() == null) {
                sb.append(SqlOperator.IS.getOperator());
            } else {
                sb.append(operator.getOperator());
            }
            sb.append(" ");
            if (operator == SqlOperator.IN) {
                sb.append("(");
                sb.append(this.getRight().getSqlAndValue(config, values));
                sb.append(")");
            } else {
                sb.append(this.getRight().getSqlAndValue(config, values));
            }
        }
        return sb.toString();
    }
}

