/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.api.crud.read;

import io.github.kiryu1223.expressionTree.delegate.Action1;
import io.github.kiryu1223.expressionTree.expressions.ExprTree;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.noear.solon.data.sqlink.annotation.RelationType;
import org.noear.solon.data.sqlink.api.crud.CRUD;
import org.noear.solon.data.sqlink.api.crud.read.EndQuery;
import org.noear.solon.data.sqlink.api.crud.read.IncludeCond;
import org.noear.solon.data.sqlink.api.crud.read.LQuery;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlGroupByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSelectExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlUnaryExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.metaData.IMappingTable;
import org.noear.solon.data.sqlink.base.metaData.NavigateData;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.base.toBean.Include.IncludeFactory;
import org.noear.solon.data.sqlink.base.toBean.Include.IncludeSet;
import org.noear.solon.data.sqlink.base.toBean.build.ObjectBuilder;
import org.noear.solon.data.sqlink.core.exception.SqLinkException;
import org.noear.solon.data.sqlink.core.page.PagedResult;
import org.noear.solon.data.sqlink.core.page.Pager;
import org.noear.solon.data.sqlink.core.sqlBuilder.QuerySqlBuilder;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;
import org.noear.solon.data.sqlink.core.visitor.GroupByVisitor;
import org.noear.solon.data.sqlink.core.visitor.HavingVisitor;
import org.noear.solon.data.sqlink.core.visitor.NormalVisitor;
import org.noear.solon.data.sqlink.core.visitor.SelectVisitor;
import org.noear.solon.data.sqlink.core.visitor.methods.AggregateMethods;
import org.noear.solon.data.sqlink.core.visitor.methods.LogicExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryBase
extends CRUD {
    public static final Logger log = LoggerFactory.getLogger(QueryBase.class);
    private final QuerySqlBuilder sqlBuilder;

    public QueryBase(QuerySqlBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    protected QuerySqlBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    @Override
    protected SqLinkConfig getConfig() {
        return this.sqlBuilder.getConfig();
    }

    protected boolean any() {
        SqLinkConfig config = this.getConfig();
        ISqlQueryableExpression queryableCopy = this.getSqlBuilder().getQueryable().copy(config);
        QuerySqlBuilder querySqlBuilder = new QuerySqlBuilder(config, queryableCopy);
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        querySqlBuilder.setSelect(factory.select(Collections.singletonList(factory.constString("1")), Integer.TYPE));
        querySqlBuilder.setLimit(0L, 1L);
        SqlSession session = this.getConfig().getSqlSessionFactory().getSession(config);
        ArrayList<SqlValue> values = new ArrayList<SqlValue>();
        String sql = querySqlBuilder.getSqlAndValue(values);
        this.tryPrintSql(log, sql);
        return session.executeQuery(ResultSet::next, sql, values);
    }

    protected <T> List<T> toList() {
        SqLinkConfig config = this.getConfig();
        boolean single = this.sqlBuilder.isSingle();
        List mappingData = single ? Collections.emptyList() : this.sqlBuilder.getMappingData();
        ArrayList<SqlValue> values = new ArrayList<SqlValue>();
        String sql = this.sqlBuilder.getSqlAndValue(values);
        this.tryPrintSql(log, sql);
        Class<?> targetClass = this.sqlBuilder.getTargetClass();
        SqlSession session = config.getSqlSessionFactory().getSession(config);
        List ts = session.executeQuery(r -> ObjectBuilder.start(r, targetClass, mappingData, single, config).createList(), sql, values);
        if (!this.sqlBuilder.getIncludeSets().isEmpty()) {
            try {
                IncludeFactory includeFactory = config.getIncludeFactory();
                includeFactory.getBuilder(this.getConfig(), session, targetClass, ts, this.sqlBuilder.getIncludeSets(), this.sqlBuilder.getQueryable()).include();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return ts;
    }

    protected <T> T first() {
        ISqlQueryableExpression queryableCopy = this.getSqlBuilder().getQueryable().copy(this.getConfig());
        QuerySqlBuilder querySqlBuilder = new QuerySqlBuilder(this.getConfig(), queryableCopy);
        querySqlBuilder.getIncludeSets().addAll(this.getSqlBuilder().getIncludeSets());
        LQuery lQuery = new LQuery(querySqlBuilder);
        lQuery.limit(1L);
        List list = lQuery.toList();
        return list.isEmpty() ? null : (T)list.get(0);
    }

    protected void distinct0(boolean condition) {
        this.sqlBuilder.setDistinct(condition);
    }

    protected <R> EndQuery<R> select(Class<R> r) {
        this.select0(r);
        return new EndQuery(this.boxedQuerySqlBuilder());
    }

    protected boolean select(LambdaExpression<?> lambda) {
        ISqlSelectExpression selectExpression;
        SelectVisitor selectVisitor = new SelectVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        Object expression = selectVisitor.visit((LambdaExpression)lambda);
        if (expression instanceof ISqlSelectExpression) {
            selectExpression = (ISqlSelectExpression)expression;
        } else {
            SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
            if (ExpressionUtil.isBool(lambda.getReturnType())) {
                SqLinkConfig config = this.getConfig();
                switch (config.getDbType()) {
                    case SQLServer: 
                    case Oracle: {
                        expression = LogicExpression.IfExpression(config, (ISqlExpression)expression, factory.constString("1"), factory.constString("0"));
                    }
                }
            }
            selectExpression = factory.select(Collections.singletonList(expression), lambda.getReturnType(), true, false);
        }
        this.sqlBuilder.setSelect(selectExpression);
        return this.sqlBuilder.isSingle();
    }

    protected void select0(Class<?> c) {
        this.sqlBuilder.setSelect(c);
    }

    protected void join(JoinType joinType, Class<?> target, ExprTree<?> expr) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object on = normalVisitor.visit(expr.getTree());
        this.sqlBuilder.addJoin(joinType, factory.table(target), (ISqlExpression)on);
    }

    protected void join(JoinType joinType, QueryBase target, ExprTree<?> expr) {
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object on = normalVisitor.visit(expr.getTree());
        this.sqlBuilder.addJoin(joinType, target.getSqlBuilder().getQueryable(), (ISqlExpression)on);
    }

    protected void where(LambdaExpression<?> lambda) {
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object where = normalVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addWhere((ISqlExpression)where);
    }

    protected void orWhere(LambdaExpression<?> lambda) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object where = normalVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addOrWhere((ISqlExpression)where);
    }

    protected void exists(Class<?> table, LambdaExpression<?> lambda, boolean not) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object where = normalVisitor.visit((LambdaExpression)lambda);
        int offset = this.sqlBuilder.getQueryable().getOrderedCount();
        QuerySqlBuilder querySqlBuilder = new QuerySqlBuilder(this.getConfig(), factory.queryable(factory.from(factory.table(table), offset)));
        querySqlBuilder.setSelect(factory.select(Collections.singletonList(factory.constString("1")), table, true, false));
        querySqlBuilder.addWhere((ISqlExpression)where);
        ISqlUnaryExpression exists = factory.unary(SqlOperator.EXISTS, querySqlBuilder.getQueryable());
        if (not) {
            this.sqlBuilder.addWhere(factory.unary(SqlOperator.NOT, exists));
        } else {
            this.sqlBuilder.addWhere(exists);
        }
    }

    protected void exists(QueryBase queryBase, LambdaExpression<?> lambda, boolean not) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object where = normalVisitor.visit((LambdaExpression)lambda);
        ISqlQueryableExpression queryable = queryBase.getSqlBuilder().getQueryable();
        int offset = this.sqlBuilder.getQueryable().getOrderedCount();
        QuerySqlBuilder querySqlBuilder = new QuerySqlBuilder(this.getConfig(), factory.queryable(factory.from(queryable, offset)));
        querySqlBuilder.setSelect(factory.select(Collections.singletonList(factory.constString("1")), queryable.getTableClass(), true, false));
        querySqlBuilder.addWhere((ISqlExpression)where);
        ISqlUnaryExpression exists = factory.unary(SqlOperator.EXISTS, querySqlBuilder.getQueryable());
        if (not) {
            this.sqlBuilder.addWhere(factory.unary(SqlOperator.NOT, exists));
        } else {
            this.sqlBuilder.addWhere(exists);
        }
    }

    protected void groupBy(LambdaExpression<?> lambda) {
        ISqlGroupByExpression group;
        GroupByVisitor groupByVisitor = new GroupByVisitor(this.getConfig());
        Object expression = groupByVisitor.visit((LambdaExpression)lambda);
        if (expression instanceof ISqlGroupByExpression) {
            group = (ISqlGroupByExpression)expression;
        } else {
            SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
            LinkedHashMap<String, ISqlExpression> map = new LinkedHashMap<String, ISqlExpression>();
            map.put("key", (ISqlExpression)expression);
            group = factory.groupBy(map);
        }
        this.sqlBuilder.setGroup(group);
    }

    protected void having(LambdaExpression<?> lambda) {
        HavingVisitor havingVisitor = new HavingVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        Object expression = havingVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addHaving((ISqlExpression)expression);
    }

    protected void orderBy(LambdaExpression<?> lambda, boolean asc) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        HavingVisitor havingVisitor = new HavingVisitor(this.getConfig(), this.sqlBuilder.getQueryable());
        Object expression = havingVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addOrder(factory.order((ISqlExpression)expression, asc));
    }

    protected void limit0(long rows) {
        this.limit0(0L, rows);
    }

    protected void limit0(long offset, long rows) {
        this.sqlBuilder.setLimit(offset, rows);
    }

    protected void singleCheck(boolean single) {
        if (single) {
            throw new RuntimeException("query.select(Func<T1,T2..., R> expr) \u4e0d\u5141\u8bb8\u4f20\u5165\u5355\u4e2a\u5143\u7d20, \u5355\u5143\u7d20\u8bf7\u4f7f\u7528endSelect");
        }
    }

    @Override
    public String toSql() {
        return this.sqlBuilder.getSql();
    }

    protected QuerySqlBuilder boxedQuerySqlBuilder() {
        return new QuerySqlBuilder(this.getConfig(), this.getConfig().getSqlExpressionFactory().queryable(this.sqlBuilder.getQueryable()));
    }

    protected void include(LambdaExpression<?> lambda, LambdaExpression<?> cond, List<IncludeSet> includeSets) {
        IncludeSet includeSet;
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object expression = normalVisitor.visit((LambdaExpression)lambda);
        if (expression instanceof ISqlColumnExpression) {
            ISqlColumnExpression columnExpression = (ISqlColumnExpression)expression;
            if (!columnExpression.getPropertyMetaData().hasNavigate()) {
                throw new RuntimeException("include\u6307\u5b9a\u7684\u5b57\u6bb5\u9700\u8981\u88ab@Navigate\u4fee\u9970");
            }
            this.relationTypeCheck(columnExpression.getPropertyMetaData().getNavigateData());
            if (cond != null) {
                NormalVisitor normalVisitor2 = new NormalVisitor(this.getConfig());
                Object condition = normalVisitor2.visit((LambdaExpression)cond);
                includeSet = new IncludeSet(columnExpression, (ISqlExpression)condition);
            } else {
                includeSet = new IncludeSet(columnExpression);
            }
        } else {
            throw new RuntimeException("include\u9700\u8981\u6307\u5b9a\u4e00\u4e2a\u5b57\u6bb5");
        }
        includeSets.add(includeSet);
    }

    protected void include(LambdaExpression<?> lambda, LambdaExpression<?> cond) {
        this.include(lambda, cond, this.sqlBuilder.getIncludeSets());
    }

    protected void include(LambdaExpression<?> lambda) {
        this.include(lambda, null, this.sqlBuilder.getIncludeSets());
    }

    protected <R> void includeByCond(LambdaExpression<?> lambda, Action1<IncludeCond<R>> action, List<IncludeSet> includeSets) {
        FieldMetaData fieldMetaData;
        ISqlColumnExpression columnExpression;
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object expression = normalVisitor.visit((LambdaExpression)lambda);
        if (expression instanceof ISqlColumnExpression) {
            columnExpression = (ISqlColumnExpression)expression;
            fieldMetaData = columnExpression.getPropertyMetaData();
            if (!columnExpression.getPropertyMetaData().hasNavigate()) {
                throw new RuntimeException("include\u6307\u5b9a\u7684\u5b57\u6bb5\u9700\u8981\u88ab@Navigate\u4fee\u9970");
            }
        } else {
            throw new RuntimeException("include\u9700\u8981\u6307\u5b9a\u4e00\u4e2a\u5b57\u6bb5");
        }
        this.relationTypeCheck(columnExpression.getPropertyMetaData().getNavigateData());
        Class<?> navigateTargetType = fieldMetaData.getNavigateData().getNavigateTargetType();
        IncludeCond temp = new IncludeCond(new QuerySqlBuilder(this.getConfig(), this.getConfig().getSqlExpressionFactory().queryable(navigateTargetType)));
        action.invoke(temp);
        IncludeSet includeSet = new IncludeSet(columnExpression, temp.getSqlBuilder().getQueryable());
        includeSets.add(includeSet);
    }

    protected <R> void includeByCond(LambdaExpression<?> lambda, Action1<IncludeCond<R>> action) {
        this.includeByCond(lambda, action, this.sqlBuilder.getIncludeSets());
    }

    protected void relationTypeCheck(NavigateData navigateData) {
        RelationType relationType = navigateData.getRelationType();
        switch (relationType) {
            case OneToOne: 
            case ManyToOne: {
                if (!navigateData.isCollectionWrapper()) break;
                throw new SqLinkException((Object)((Object)relationType) + "\u4e0d\u652f\u6301\u96c6\u5408");
            }
            case OneToMany: {
                if (navigateData.isCollectionWrapper()) break;
                if (!List.class.isAssignableFrom(navigateData.getCollectionWrapperType()) && !Set.class.isAssignableFrom(navigateData.getCollectionWrapperType())) {
                    throw new SqLinkException((Object)((Object)relationType) + "\u53ea\u652f\u6301List\u548cSet");
                }
                throw new SqLinkException((Object)((Object)relationType) + "\u53ea\u652f\u6301\u96c6\u5408");
            }
            case ManyToMany: {
                if (navigateData.getMappingTableType() == IMappingTable.class || navigateData.getSelfMappingFieldName().isEmpty() || navigateData.getTargetMappingFieldName().isEmpty()) {
                    throw new SqLinkException((Object)((Object)relationType) + "\u4e0b@Navigate\u6ce8\u89e3\u7684midTable\u548cSelfMapping\u548cTargetMapping\u5b57\u6bb5\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (navigateData.isCollectionWrapper()) break;
                if (!List.class.isAssignableFrom(navigateData.getCollectionWrapperType()) && !Set.class.isAssignableFrom(navigateData.getCollectionWrapperType())) {
                    throw new SqLinkException((Object)((Object)relationType) + "\u53ea\u652f\u6301List\u548cSet");
                }
                throw new RuntimeException((Object)((Object)relationType) + "\u53ea\u652f\u6301\u96c6\u5408");
            }
        }
    }

    protected <T> PagedResult<T> toPagedResult0(long pageIndex, long pageSize, Pager pager) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        QuerySqlBuilder boxedQuerySqlBuilder = this.boxedQuerySqlBuilder();
        boxedQuerySqlBuilder.setSelect(factory.select(Collections.singletonList(AggregateMethods.count(this.getConfig(), null)), Long.TYPE, true, false));
        LQuery countQuery = new LQuery(boxedQuerySqlBuilder);
        long total = (Long)countQuery.toList().get(0);
        QuerySqlBuilder dataQuerySqlBuilder = new QuerySqlBuilder(this.getConfig(), this.getSqlBuilder().getQueryable().copy(this.getConfig()));
        dataQuerySqlBuilder.getIncludeSets().addAll(dataQuerySqlBuilder.getIncludeSets());
        LQuery dataQuery = new LQuery(dataQuerySqlBuilder);
        long take = Math.max(pageSize, 1L);
        long index = Math.max(pageIndex, 1L);
        long offset = (index - 1L) * take;
        List list = dataQuery.limit(offset, take).toList();
        return pager.getPagedResult(total, list);
    }
}

