/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.plugin.integration;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.noear.solon.annotation.Inject;
import org.noear.solon.aot.RuntimeNativeRegistrar;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.data.datasource.DsUtils;
import org.noear.solon.data.sqlink.api.client.SQLinkClient;
import org.noear.solon.data.sqlink.base.DbType;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.session.DefaultSqlSessionFactory;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.TypeHandlerManager;
import org.noear.solon.data.sqlink.core.SQLink;
import org.noear.solon.data.sqlink.plugin.aot.SQLinkRuntimeNativeRegistrar;
import org.noear.solon.data.sqlink.plugin.builder.AotBeanCreatorFactory;
import org.noear.solon.data.sqlink.plugin.configuration.SQLinkProperties;
import org.noear.solon.data.sqlink.plugin.datasource.SolonDataSourceManager;
import org.noear.solon.data.sqlink.plugin.datasource.SolonDataSourceManagerWrap;
import org.noear.solon.data.sqlink.plugin.transaction.SolonTransactionManager;

public class XPluginImpl
implements Plugin {
    public void start(AppContext context) throws Throwable {
        System.out.println("SQLink\u542f\u52a8");
        Map data = context.cfg().getGroupedProp("solon.data.sqlink");
        if (data.isEmpty()) {
            return;
        }
        LinkedHashMap clients = new LinkedHashMap();
        for (Map.Entry entry : data.entrySet()) {
            Props props = (Props)entry.getValue();
            SQLinkProperties properties = (SQLinkProperties)props.toBean(SQLinkProperties.class);
            String dsName = (String)entry.getKey();
            if (dsName.isEmpty()) continue;
            SolonDataSourceManagerWrap dataSourceManager = new SolonDataSourceManagerWrap();
            SolonTransactionManager transactionManager = new SolonTransactionManager(dataSourceManager);
            DefaultSqlSessionFactory sqlSessionFactory = new DefaultSqlSessionFactory(dataSourceManager, transactionManager);
            AotBeanCreatorFactory aotFastCreatorFactory = new AotBeanCreatorFactory();
            SQLinkClient SQLinkClient2 = SQLink.bootStrap().setDataSourceManager(dataSourceManager).setTransactionManager(transactionManager).setSqlSessionFactory(sqlSessionFactory).setFastCreatorFactory(aotFastCreatorFactory).setOption(properties.bulidOption()).build();
            clients.put(entry.getKey(), SQLinkClient2);
            IConfig config = SQLinkClient2.getConfig();
            DsUtils.observeDs((AppContext)context, (String)dsName, beanWrap -> XPluginImpl.registerDataSource(beanWrap, config));
        }
        context.beanInjectorAdd(Inject.class, SQLinkClient.class, (varHolder, inject) -> {
            varHolder.required(inject.required());
            String name = inject.value();
            if (name.isEmpty()) {
                Optional first = clients.values().stream().findFirst();
                varHolder.setValue(first.orElseThrow(RuntimeException::new));
            } else {
                varHolder.setValue(clients.get(name));
            }
        });
        context.getBeanAsync(ITypeHandler.class, TypeHandlerManager::set);
        this.registerAot(context);
    }

    private static void registerDataSource(BeanWrap beanWrap, IConfig config) {
        SolonDataSourceManagerWrap sourceManagerWrap = (SolonDataSourceManagerWrap)config.getDataSourceManager();
        sourceManagerWrap.setDataSourceManager(new SolonDataSourceManager((DataSource)beanWrap.get()));
        try (Connection connection = sourceManagerWrap.getConnection();){
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            DbType dbType = DbType.getByName(databaseProductName);
            config.setDbType(dbType);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void registerAot(AppContext context) {
        if (NativeDetector.isAotRuntime() && ClassUtil.hasClass(() -> RuntimeNativeRegistrar.class)) {
            context.wrapAndPut(SQLinkRuntimeNativeRegistrar.class, (Object)new SQLinkRuntimeNativeRegistrar());
        }
    }
}

