/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.visitor;

import io.github.kiryu1223.expressionTree.expressions.BlockExpression;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.NewExpression;
import io.github.kiryu1223.expressionTree.expressions.OperatorType;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.UnaryExpression;
import io.github.kiryu1223.expressionTree.expressions.VariableExpression;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.metaData.PropertyMetaData;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;
import org.noear.solon.data.sqlink.core.visitor.SqlVisitor;
import org.noear.solon.data.sqlink.core.visitor.methods.LogicExpression;

public class SelectVisitor
extends SqlVisitor {
    private final ISqlQueryableExpression queryable;

    public SelectVisitor(IConfig config, ISqlQueryableExpression queryable) {
        super(config);
        this.queryable = queryable;
    }

    @Override
    public ISqlExpression visit(NewExpression newExpression) {
        BlockExpression classBody = newExpression.getClassBody();
        if (classBody == null) {
            return super.visit(newExpression);
        }
        ArrayList<ISqlExpression> expressions = new ArrayList<ISqlExpression>();
        for (Expression expression : classBody.getExpressions()) {
            if (expression.getKind() != Kind.Variable) continue;
            VariableExpression variable = (VariableExpression)expression;
            String name = variable.getName();
            MetaData metaData = MetaDataCache.getMetaData(newExpression.getType());
            Expression init = variable.getInit();
            if (init == null) continue;
            ISqlExpression context = (ISqlExpression)this.visit(variable.getInit());
            context = this.boxTheBool(variable.getInit(), context);
            this.setAs(expressions, context, name);
        }
        return this.factory.select(expressions, newExpression.getType());
    }

    @Override
    public ISqlExpression visit(FieldSelectExpression fieldSelect) {
        if (ExpressionUtil.isGroupKey(this.parameters, (Expression)fieldSelect)) {
            return this.queryable.getGroupBy().getColumns().get("key");
        }
        if (ExpressionUtil.isGroupKey(this.parameters, fieldSelect.getExpr())) {
            LinkedHashMap<String, ISqlExpression> columns = this.queryable.getGroupBy().getColumns();
            return (ISqlExpression)columns.get(fieldSelect.getField().getName());
        }
        return super.visit(fieldSelect);
    }

    @Override
    protected SqlVisitor getSelf() {
        return new SelectVisitor(this.config, this.queryable);
    }

    public ISqlExpression visit(ParameterExpression parameter) {
        if (this.parameters.contains(parameter)) {
            Class type = parameter.getType();
            int index = this.parameters.indexOf(parameter);
            MetaData metaData = MetaDataCache.getMetaData(type);
            ArrayList<ISqlExpression> expressions = new ArrayList<ISqlExpression>();
            for (PropertyMetaData pm : metaData.getNotIgnorePropertys()) {
                expressions.add(this.factory.column(pm, index));
            }
            return this.factory.select(expressions, parameter.getType());
        }
        return (ISqlExpression)super.visit(parameter);
    }

    protected void setAs(List<ISqlExpression> contexts, ISqlExpression expression, String name) {
        if (expression instanceof ISqlColumnExpression) {
            ISqlColumnExpression sqlColumn = (ISqlColumnExpression)expression;
            if (!sqlColumn.getPropertyMetaData().getColumn().equals(name)) {
                contexts.add(this.factory.as(expression, name));
            } else {
                contexts.add(expression);
            }
        } else {
            contexts.add(this.factory.as(expression, name));
        }
    }

    protected ISqlExpression boxTheBool(Expression init, ISqlExpression result) {
        if (init instanceof MethodCallExpression) {
            MethodCallExpression methodCall = (MethodCallExpression)init;
            return this.boxTheBool(ExpressionUtil.isBool(methodCall.getMethod().getReturnType()), result);
        }
        if (init instanceof UnaryExpression) {
            UnaryExpression unary = (UnaryExpression)init;
            return this.boxTheBool(unary.getOperatorType() == OperatorType.NOT, result);
        }
        return result;
    }

    protected ISqlExpression boxTheBool(boolean condition, ISqlExpression result) {
        if (!condition) {
            return result;
        }
        switch (this.config.getDbType()) {
            case SQLServer: 
            case Oracle: {
                return LogicExpression.IfExpression(this.config, result, this.factory.constString("1"), this.factory.constString("0"));
            }
        }
        return result;
    }
}

