/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlBuilder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.IDialect;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWhereExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.core.sqlBuilder.ISqlBuilder;

public class DeleteSqlBuilder
implements ISqlBuilder {
    private final IConfig config;
    private final ISqlJoinsExpression joins;
    private final ISqlWhereExpression wheres;
    private final Class<?> target;
    private final Set<Integer> excludes = new HashSet<Integer>();
    private final SqlExpressionFactory factory;
    private final List<Class<?>> orderedClasses = new ArrayList();

    public DeleteSqlBuilder(IConfig config, Class<?> target) {
        this.config = config;
        this.target = target;
        this.factory = config.getSqlExpressionFactory();
        this.joins = this.factory.Joins();
        this.wheres = this.factory.where();
        this.orderedClasses.add(target);
    }

    public void addJoin(Class<?> target, JoinType joinType, ISqlTableExpression table, ISqlExpression on) {
        ISqlJoinExpression join = this.factory.join(joinType, table, on, 1 + this.joins.getJoins().size());
        this.joins.addJoin(join);
        this.orderedClasses.add(table.getTableClass());
    }

    public void addExclude(Class<?> c) {
        this.excludes.add(this.orderedClasses.indexOf(c));
    }

    public void addWhere(ISqlExpression where) {
        this.wheres.addCondition(where);
    }

    @Override
    public IConfig getConfig() {
        return this.config;
    }

    public boolean hasWhere() {
        return !this.wheres.isEmpty();
    }

    @Override
    public String getSql() {
        String wheresSql;
        ArrayList<String> strings = new ArrayList<String>(3);
        String sql = this.makeDelete();
        strings.add(sql);
        String joinsSql = this.joins.getSql(this.config);
        if (!joinsSql.isEmpty()) {
            strings.add(joinsSql);
        }
        if (!(wheresSql = this.wheres.getSql(this.config)).isEmpty()) {
            strings.add(wheresSql);
        }
        return String.join((CharSequence)" ", strings);
    }

    @Override
    public String getSqlAndValue(List<Object> values) {
        String wheresSql;
        ArrayList<String> strings = new ArrayList<String>(3);
        String sql = this.makeDelete();
        strings.add(sql);
        String joinsSql = this.joins.getSqlAndValue(this.config, values);
        if (!joinsSql.isEmpty()) {
            strings.add(joinsSql);
        }
        if (!(wheresSql = this.wheres.getSqlAndValue(this.config, values)).isEmpty()) {
            strings.add(wheresSql);
        }
        return String.join((CharSequence)" ", strings);
    }

    private String makeDelete() {
        StringBuilder builder = new StringBuilder("DELETE");
        if (!this.excludes.isEmpty()) {
            builder.append(" ");
            ArrayList<String> strings = new ArrayList<String>(this.excludes.size());
            for (int index : this.excludes) {
                if (index == -1) continue;
                strings.add("t" + index);
            }
            builder.append(String.join((CharSequence)",", strings));
        }
        IDialect dbConfig = this.config.getDisambiguation();
        MetaData metaData = MetaDataCache.getMetaData(this.target);
        return builder.append(" FROM ").append(dbConfig.disambiguationTableName(metaData.getTableName())).append(" AS t0").toString();
    }
}

