/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.metaData;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.noear.solon.data.sqlink.base.metaData.NavigateData;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;

public class PropertyMetaData {
    private final String property;
    private final String column;
    private final Method getter;
    private final Method setter;
    private final Field field;
    private final boolean isGenericType;
    private final boolean useTypeHandler;
    private final ITypeHandler<?> typeHandler;
    private final boolean ignoreColumn;
    private final NavigateData navigateData;
    private final boolean isPrimaryKey;

    public PropertyMetaData(String property, String column, Method getter, Method setter, Field field, boolean useTypeHandler, ITypeHandler<?> typeHandler, boolean ignoreColumn, NavigateData navigateData, boolean isPrimaryKey) {
        this.property = property;
        this.column = column;
        this.ignoreColumn = ignoreColumn;
        this.isPrimaryKey = isPrimaryKey;
        getter.setAccessible(true);
        this.getter = getter;
        setter.setAccessible(true);
        this.setter = setter;
        this.field = field;
        this.useTypeHandler = useTypeHandler;
        this.typeHandler = typeHandler;
        this.navigateData = navigateData;
        this.isGenericType = field.getGenericType() instanceof ParameterizedType;
    }

    public String getProperty() {
        return this.property;
    }

    public String getColumn() {
        return this.column;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isIgnoreColumn() {
        return this.ignoreColumn;
    }

    public boolean hasNavigate() {
        return this.navigateData != null;
    }

    public NavigateData getNavigateData() {
        return this.navigateData;
    }

    public Class<?> getParentType() {
        return this.field.getDeclaringClass();
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public boolean isGenericType() {
        return this.isGenericType;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public ITypeHandler<?> getTypeHandler() {
        return this.typeHandler;
    }

    public boolean isUseTypeHandler() {
        return this.useTypeHandler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyMetaData that = (PropertyMetaData)o;
        return this.isGenericType == that.isGenericType && this.useTypeHandler == that.useTypeHandler && this.ignoreColumn == that.ignoreColumn && this.isPrimaryKey == that.isPrimaryKey && Objects.equals(this.property, that.property) && Objects.equals(this.column, that.column) && Objects.equals(this.getter, that.getter) && Objects.equals(this.setter, that.setter) && Objects.equals(this.field, that.field) && Objects.equals(this.typeHandler, that.typeHandler) && Objects.equals(this.navigateData, that.navigateData);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.column, this.getter, this.setter, this.field, this.isGenericType, this.useTypeHandler, this.typeHandler, this.ignoreColumn, this.navigateData, this.isPrimaryKey);
    }
}

