/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.session;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.noear.solon.data.sqlink.base.dataSource.DataSourceManager;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.metaData.PropertyMetaData;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.TypeHandlerManager;
import org.noear.solon.data.sqlink.base.transaction.TransactionManager;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;

public class DefaultSqlSession
implements SqlSession {
    protected final DataSourceManager dataSourceManager;
    protected final TransactionManager transactionManager;

    public DefaultSqlSession(DataSourceManager dataSourceManager, TransactionManager transactionManager) {
        this.dataSourceManager = dataSourceManager;
        this.transactionManager = transactionManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R executeQuery(SqlSession.Function<ResultSet, R> func, String sql, Collection<Object> values) {
        if (!this.transactionManager.currentThreadInTransaction()) {
            try (Connection connection = this.dataSourceManager.getConnection();){
                R r = this.executeQuery(connection, func, sql, values);
                return r;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Connection connection;
            if (this.transactionManager.isOpenTransaction()) {
                connection = this.transactionManager.getCurTransaction().getConnection();
                return this.executeQuery(connection, func, sql, values);
            }
            connection = this.dataSourceManager.getConnection();
            return this.executeQuery(connection, func, sql, values);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private <R> R executeQuery(Connection connection, SqlSession.Function<ResultSet, R> func, String sql, Collection<Object> values) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long executeInsert(String sql, List<Object> values) {
        if (!this.transactionManager.currentThreadInTransaction()) {
            try (Connection connection = this.dataSourceManager.getConnection();){
                long l = this.executeInsert(connection, sql, values);
                return l;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Connection connection;
            if (this.transactionManager.isOpenTransaction()) {
                connection = this.transactionManager.getCurTransaction().getConnection();
                return this.executeInsert(connection, sql, values);
            }
            connection = this.dataSourceManager.getConnection();
            return this.executeInsert(connection, sql, values);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long executeDelete(String sql, List<Object> values) {
        return this.executeUpdate(sql, values);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long executeUpdate(String sql, List<Object> values) {
        if (!this.transactionManager.currentThreadInTransaction()) {
            try (Connection connection = this.dataSourceManager.getConnection();){
                long l = this.executeUpdate(connection, sql, values, new Object[0]);
                return l;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Connection connection;
            if (this.transactionManager.isOpenTransaction()) {
                connection = this.transactionManager.getCurTransaction().getConnection();
                return this.executeUpdate(connection, sql, values, new Object[0]);
            }
            connection = this.dataSourceManager.getConnection();
            return this.executeUpdate(connection, sql, values, new Object[0]);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long executeInsert(Connection connection, String sql, Collection<Object> values) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            DefaultSqlSession.setObjectsByEntity(preparedStatement, values);
            if (values.size() == 1) {
                long l = preparedStatement.executeUpdate();
                return l;
            }
            long l = preparedStatement.executeBatch().length;
            return l;
        }
        catch (IllegalAccessException | InvocationTargetException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long executeUpdate(Connection connection, String sql, Collection<Object> values, Object ... o) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            this.setObjects(preparedStatement, values);
            long l = preparedStatement.executeUpdate();
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setObjects(PreparedStatement preparedStatement, Collection<Object> values) throws SQLException {
        int index = 1;
        for (Object value : values) {
            if (value instanceof SqlValue) {
                SqlValue sqlValue = (SqlValue)value;
                sqlValue.preparedStatementSetValue(preparedStatement, index++);
                continue;
            }
            TypeHandlerManager.get(value.getClass()).setValue(preparedStatement, index++, value);
        }
    }

    protected static void setObjectsByEntity(PreparedStatement preparedStatement, Collection<Object> values) throws SQLException, InvocationTargetException, IllegalAccessException {
        boolean batch = values.size() > 1;
        for (Object value : values) {
            int index = 1;
            MetaData metaData = MetaDataCache.getMetaData(value.getClass());
            for (PropertyMetaData propertyMetaData : metaData.getNotIgnorePropertys()) {
                if (propertyMetaData.isPrimaryKey()) continue;
                ITypeHandler<?> typeHandler = propertyMetaData.getTypeHandler();
                typeHandler.setValue(preparedStatement, index++, ExpressionUtil.cast(propertyMetaData.getGetter().invoke(value, new Object[0])));
            }
            if (!batch) continue;
            preparedStatement.addBatch();
        }
    }
}

