/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.visitor;

import io.github.kiryu1223.expressionTree.expressions.BlockExpression;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.NewExpression;
import io.github.kiryu1223.expressionTree.expressions.VariableExpression;
import java.util.LinkedHashMap;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.core.visitor.SqlVisitor;

public class GroupByVisitor
extends SqlVisitor {
    public GroupByVisitor(IConfig config) {
        super(config);
    }

    @Override
    public ISqlExpression visit(NewExpression newExpression) {
        BlockExpression classBody = newExpression.getClassBody();
        if (classBody == null) {
            return super.visit(newExpression);
        }
        LinkedHashMap<String, ISqlExpression> contextMap = new LinkedHashMap<String, ISqlExpression>();
        for (Expression expression : classBody.getExpressions()) {
            if (expression.getKind() != Kind.Variable) continue;
            VariableExpression variableExpression = (VariableExpression)expression;
            String name = variableExpression.getName();
            ISqlExpression sqlExpression = (ISqlExpression)this.visit(variableExpression.getInit());
            contextMap.put(name, sqlExpression);
        }
        return this.factory.groupBy(contextMap);
    }

    @Override
    protected GroupByVisitor getSelf() {
        return new GroupByVisitor(this.config);
    }
}

