/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.api.crud.delete;

import io.github.kiryu1223.expressionTree.expressions.ExprTree;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import java.util.ArrayList;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.core.api.crud.CRUD;
import org.noear.solon.data.sqlink.core.sqlBuilder.DeleteSqlBuilder;
import org.noear.solon.data.sqlink.core.visitor.NormalVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeleteBase
extends CRUD {
    public static final Logger log = LoggerFactory.getLogger(DeleteBase.class);
    private final DeleteSqlBuilder sqlBuilder;

    public DeleteBase(IConfig config, Class<?> target) {
        this.sqlBuilder = new DeleteSqlBuilder(config, target);
    }

    public DeleteBase(DeleteSqlBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    protected DeleteSqlBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    @Override
    public IConfig getConfig() {
        return this.sqlBuilder.getConfig();
    }

    public long executeRows() {
        IConfig config = this.getConfig();
        this.checkHasWhere();
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = this.sqlBuilder.getSqlAndValue(values);
        this.tryPrintUseDs(log, config.getDataSourceManager().getDsKey());
        this.tryPrintSql(log, sql);
        SqlSession session = config.getSqlSessionFactory().getSession();
        return session.executeUpdate(sql, values, new Object[0]);
    }

    public String toSql() {
        return this.sqlBuilder.getSql();
    }

    private void checkHasWhere() {
        if (this.getConfig().isIgnoreDeleteNoWhere()) {
            return;
        }
        if (!this.sqlBuilder.hasWhere()) {
            throw new RuntimeException("DELETE\u6ca1\u6709\u6761\u4ef6");
        }
    }

    protected void join(JoinType joinType, Class<?> target, ExprTree<?> expr) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object on = normalVisitor.visit(expr.getTree());
        this.getSqlBuilder().addJoin(target, joinType, factory.table(target), (ISqlExpression)on);
    }

    protected void selectDeleteTable(Class<?> c) {
        this.getSqlBuilder().addExclude(c);
    }

    protected void where(LambdaExpression<?> lambda) {
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object expression = normalVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addWhere((ISqlExpression)expression);
    }
}

