/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.api.crud.create;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.IDialect;
import org.noear.solon.data.sqlink.base.metaData.IConverter;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.metaData.PropertyMetaData;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.core.api.crud.CRUD;
import org.noear.solon.data.sqlink.core.sqlBuilder.InsertSqlBuilder;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InsertBase
extends CRUD {
    public static final Logger log = LoggerFactory.getLogger(InsertBase.class);
    private final InsertSqlBuilder sqlBuilder;

    protected InsertSqlBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    @Override
    protected IConfig getConfig() {
        return this.sqlBuilder.getConfig();
    }

    public InsertBase(IConfig c) {
        this.sqlBuilder = new InsertSqlBuilder(c);
    }

    public long executeRows() {
        List<Object> objects = this.getObjects();
        if (!objects.isEmpty()) {
            return this.objectsExecuteRows(objects);
        }
        return 0L;
    }

    public String toSql() {
        List<Object> objects = this.getObjects();
        if (!objects.isEmpty()) {
            return this.makeByObjects(objects, null);
        }
        return this.sqlBuilder.getSql();
    }

    protected <T> List<T> getObjects() {
        return Collections.emptyList();
    }

    protected abstract <T> Class<T> getTableType();

    private long objectsExecuteRows(List<Object> objects) {
        IConfig config = this.getConfig();
        ArrayList<SqlValue> sqlValues = new ArrayList<SqlValue>();
        String sql = this.makeByObjects(objects, sqlValues);
        this.tryPrintUseDs(log, config.getDataSourceManager().getDsKey());
        this.tryPrintSql(log, sql);
        SqlSession session = config.getSqlSessionFactory().getSession();
        if (objects.size() > 1) {
            this.tryPrintBatch(log, objects.size());
            return session.batchExecuteUpdate(sql, objects.size(), sqlValues);
        }
        this.tryPrintNoBatch(log, objects.size());
        return session.executeUpdate(sql, sqlValues);
    }

    private String makeByObjects(List<Object> objects, List<SqlValue> sqlValues) {
        MetaData metaData = MetaDataCache.getMetaData(this.getTableType());
        ArrayList<String> tableFields = new ArrayList<String>();
        ArrayList<String> tableValues = new ArrayList<String>();
        for (PropertyMetaData pro : metaData.getNotIgnorePropertys()) {
            IConverter<?, ?> converter = pro.getConverter();
            tableFields.add(pro.getColumn());
            tableValues.add("?");
            if (sqlValues == null) continue;
            ArrayList<Object> values = new ArrayList<Object>(objects.size());
            if (pro.hasConverter()) {
                for (Object o : objects) {
                    try {
                        Object obj = pro.getGetter().invoke(o, new Object[0]);
                        if (obj != null) {
                            values.add(converter.toDb(ExpressionUtil.cast(obj), pro));
                            continue;
                        }
                        values.add(null);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                sqlValues.add(new SqlValue(converter.getDbType(), values));
                continue;
            }
            for (Object o : objects) {
                try {
                    values.add(pro.getGetter().invoke(o, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            sqlValues.add(new SqlValue(pro.getField().getType(), values));
        }
        IDialect dialect = this.getSqlBuilder().getConfig().getDisambiguation();
        return "INSERT INTO " + dialect.disambiguationTableName(metaData.getTableName()) + "(" + String.join((CharSequence)",", tableFields) + ") VALUES(" + String.join((CharSequence)",", tableValues) + ")";
    }
}

