/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.api.client;

import io.github.kiryu1223.expressionTree.expressions.annos.Recode;
import java.util.Collection;
import java.util.Iterator;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.transaction.Transaction;
import org.noear.solon.data.sqlink.core.api.crud.create.ObjectInsert;
import org.noear.solon.data.sqlink.core.api.crud.delete.LDelete;
import org.noear.solon.data.sqlink.core.api.crud.read.EmptyQuery;
import org.noear.solon.data.sqlink.core.api.crud.read.LQuery;
import org.noear.solon.data.sqlink.core.api.crud.update.LUpdate;

public class Client {
    private final IConfig config;

    public Client(IConfig config) {
        this.config = config;
    }

    public void useDs(String key) {
        this.config.getDataSourceManager().useDs(key);
    }

    public void useDefDs() {
        this.config.getDataSourceManager().useDefDs();
    }

    public Transaction beginTransaction(Integer isolationLevel) {
        return this.config.getTransactionManager().get(isolationLevel);
    }

    public Transaction beginTransaction() {
        return this.beginTransaction(null);
    }

    public <T> LQuery<T> query(@Recode Class<T> c) {
        return new LQuery<T>(this.config, c);
    }

    public EmptyQuery queryEmptyTable() {
        return new EmptyQuery(this.config);
    }

    public <T> ObjectInsert<T> insert(@Recode T t) {
        ObjectInsert objectInsert = new ObjectInsert(this.config, t.getClass());
        return objectInsert.insert(t);
    }

    public <T> ObjectInsert<T> insert(@Recode Collection<T> ts) {
        ObjectInsert<T> objectInsert = new ObjectInsert<T>(this.config, this.getType(ts));
        return objectInsert.insert(ts);
    }

    public <T> LUpdate<T> update(@Recode Class<T> c) {
        return new LUpdate<T>(this.config, c);
    }

    public <T> LDelete<T> delete(@Recode Class<T> c) {
        return new LDelete<T>(this.config, c);
    }

    private <T> Class<T> getType(Collection<T> ts) {
        Iterator<T> iterator = ts.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            return t.getClass();
        }
        throw new RuntimeException();
    }

    public IConfig getConfig() {
        return this.config;
    }
}

