/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.toBean.handler;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.UnKnowTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.datetime.DateTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.datetime.LocalDateTimeTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.datetime.LocalDateTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.datetime.LocalTimeTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.datetime.TimeTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.datetime.TimestampTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.datetime.UtilDateHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.number.BigDecimalTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.number.BigIntegerTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.number.BoolTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.number.ByteTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.number.DoubleTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.number.FloatTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.number.IntTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.number.LongTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.number.ShortTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.other.URLTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.varchar.CharTypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.impl.varchar.StringTypeHandler;

public class TypeHandlerManager {
    private static final Map<Type, ITypeHandler<?>> cache = new HashMap();
    private static final UnKnowTypeHandler<?> unKnowTypeHandler = new UnKnowTypeHandler();

    public static <T> void set(ITypeHandler<T> typeHandler) {
        Type actualType = typeHandler.getActualType();
        TypeHandlerManager.warpBaseType(actualType, typeHandler);
        cache.put(actualType, typeHandler);
    }

    public static <T> ITypeHandler<T> get(Type type) {
        ITypeHandler<?> iTypeHandler = cache.get(type);
        if (iTypeHandler == null) {
            return unKnowTypeHandler;
        }
        return iTypeHandler;
    }

    private static void warpBaseType(Type actualType, ITypeHandler<?> typeHandler) {
        if (actualType == Character.class) {
            cache.put(Character.TYPE, typeHandler);
        } else if (actualType == Byte.class) {
            cache.put(Byte.TYPE, typeHandler);
        } else if (actualType == Short.class) {
            cache.put(Short.TYPE, typeHandler);
        } else if (actualType == Integer.class) {
            cache.put(Integer.TYPE, typeHandler);
        } else if (actualType == Long.class) {
            cache.put(Long.TYPE, typeHandler);
        } else if (actualType == Float.class) {
            cache.put(Float.TYPE, typeHandler);
        } else if (actualType == Double.class) {
            cache.put(Double.TYPE, typeHandler);
        } else if (actualType == Boolean.class) {
            cache.put(Boolean.TYPE, typeHandler);
        }
    }

    static {
        TypeHandlerManager.set(new CharTypeHandler());
        TypeHandlerManager.set(new StringTypeHandler());
        TypeHandlerManager.set(new ByteTypeHandler());
        TypeHandlerManager.set(new ShortTypeHandler());
        TypeHandlerManager.set(new IntTypeHandler());
        TypeHandlerManager.set(new LongTypeHandler());
        TypeHandlerManager.set(new BoolTypeHandler());
        TypeHandlerManager.set(new FloatTypeHandler());
        TypeHandlerManager.set(new DoubleTypeHandler());
        TypeHandlerManager.set(new BigIntegerTypeHandler());
        TypeHandlerManager.set(new BigDecimalTypeHandler());
        TypeHandlerManager.set(new DateTypeHandler());
        TypeHandlerManager.set(new UtilDateHandler());
        TypeHandlerManager.set(new TimeTypeHandler());
        TypeHandlerManager.set(new TimestampTypeHandler());
        TypeHandlerManager.set(new LocalDateTimeTypeHandler());
        TypeHandlerManager.set(new LocalDateTypeHandler());
        TypeHandlerManager.set(new LocalTimeTypeHandler());
        TypeHandlerManager.set(new URLTypeHandler());
    }
}

