/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.toBean.beancreator;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.metaData.PropertyMetaData;
import org.noear.solon.data.sqlink.base.toBean.beancreator.AbsBeanCreator;
import org.noear.solon.data.sqlink.base.toBean.beancreator.ISetterCaller;
import org.noear.solon.data.sqlink.base.toBean.beancreator.IVoidSetter;
import sun.misc.Unsafe;

public class DefaultBeanCreator<T>
extends AbsBeanCreator<T> {
    protected static final Unsafe unsafe;

    public DefaultBeanCreator(Class<T> target) {
        super(target);
    }

    @Override
    protected Supplier<T> initBeanCreator(Class<T> target) {
        if (target.isAnonymousClass()) {
            return this.unsafeCreator(target);
        }
        return this.methodHandleCreator(target);
    }

    protected Supplier<T> unsafeCreator(Class<T> target) {
        return () -> {
            try {
                return unsafe.allocateInstance(target);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        };
    }

    protected Supplier<T> methodHandleCreator(Class<T> target) {
        try {
            MethodType constructorType = MethodType.methodType(Void.TYPE);
            MethodHandles.Lookup caller = MethodHandles.lookup();
            MethodHandle constructorHandle = caller.findConstructor(target, constructorType);
            CallSite site = LambdaMetafactory.altMetafactory(caller, "get", MethodType.methodType(Supplier.class), constructorHandle.type().generic(), constructorHandle, constructorHandle.type(), 1);
            return site.getTarget().invokeExact();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ISetterCaller<T> initBeanSetter(String property) {
        if (this.target.isAnonymousClass()) {
            return this.methodBeanSetter(property);
        }
        return this.methodHandleBeanSetter(property);
    }

    protected ISetterCaller<T> methodBeanSetter(String property) {
        PropertyMetaData propertyMetaData = MetaDataCache.getMetaData(this.target).getPropertyMetaDataByFieldName(property);
        Method setter = propertyMetaData.getSetter();
        return (t, v) -> setter.invoke(t, v);
    }

    protected ISetterCaller<T> methodHandleBeanSetter(String property) {
        PropertyMetaData propertyMetaData = MetaDataCache.getMetaData(this.target).getPropertyMetaDataByFieldName(property);
        Class<?> propertyType = propertyMetaData.getType();
        MethodHandles.Lookup caller = MethodHandles.lookup();
        Method writeMethod = propertyMetaData.getSetter();
        MethodType setter = MethodType.methodType(writeMethod.getReturnType(), propertyType);
        Class<?> lambdaPropertyType = this.upperClass(propertyType);
        String getFunName = writeMethod.getName();
        try {
            MethodType instantiatedMethodType = MethodType.methodType(Void.TYPE, this.target, lambdaPropertyType);
            MethodHandle targetHandle = caller.findVirtual(this.target, getFunName, setter);
            MethodType samMethodType = MethodType.methodType(Void.TYPE, Object.class, Object.class);
            CallSite site = LambdaMetafactory.metafactory(caller, "apply", MethodType.methodType(IVoidSetter.class), samMethodType, targetHandle, instantiatedMethodType);
            IVoidSetter objectPropertyVoidSetter = site.getTarget().invokeExact();
            return objectPropertyVoidSetter::apply;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> upperClass(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Character.TYPE) {
                return Character.class;
            }
            if (c == Byte.TYPE) {
                return Byte.class;
            }
            if (c == Short.TYPE) {
                return Short.class;
            }
            if (c == Integer.TYPE) {
                return Integer.class;
            }
            if (c == Long.TYPE) {
                return Long.class;
            }
            if (c == Float.TYPE) {
                return Float.class;
            }
            if (c == Double.TYPE) {
                return Double.class;
            }
            if (c == Boolean.TYPE) {
                return Boolean.class;
            }
            return Void.class;
        }
        return c;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

