/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.plugin.integration;

import java.util.Map;
import javax.sql.DataSource;
import org.noear.solon.aot.RuntimeNativeRegistrar;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.data.datasource.DsUtils;
import org.noear.solon.data.sqlink.base.session.DefaultSqlSessionFactory;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.TypeHandlerManager;
import org.noear.solon.data.sqlink.core.SQLink;
import org.noear.solon.data.sqlink.core.api.client.Client;
import org.noear.solon.data.sqlink.plugin.aot.SQLinkRuntimeNativeRegistrar;
import org.noear.solon.data.sqlink.plugin.builder.AotBeanCreatorFactory;
import org.noear.solon.data.sqlink.plugin.configuration.SQLinkProperties;
import org.noear.solon.data.sqlink.plugin.datasource.SolonDataSourceManager;
import org.noear.solon.data.sqlink.plugin.datasource.SolonDataSourceManagerWrap;
import org.noear.solon.data.sqlink.plugin.transaction.SolonTransactionManager;

public class XPluginImpl
implements Plugin {
    public void start(AppContext context) throws Throwable {
        Map data = context.cfg().getGroupedProp("SQLink");
        for (Map.Entry entry : data.entrySet()) {
            Props props = (Props)entry.getValue();
            SQLinkProperties properties = (SQLinkProperties)props.toBean(SQLinkProperties.class);
            String dsName = properties.getDsName();
            if (dsName.isEmpty()) continue;
            SolonDataSourceManagerWrap dataSourceManager = new SolonDataSourceManagerWrap();
            SolonTransactionManager transactionManager = new SolonTransactionManager(dataSourceManager);
            DefaultSqlSessionFactory sqlSessionFactory = new DefaultSqlSessionFactory(dataSourceManager, transactionManager);
            AotBeanCreatorFactory aotFastCreatorFactory = new AotBeanCreatorFactory();
            Client client = SQLink.bootStrap().setDataSourceManager(dataSourceManager).setTransactionManager(transactionManager).setSqlSessionFactory(sqlSessionFactory).setFastCreatorFactory(aotFastCreatorFactory).setOption(properties.bulidOption()).build();
            BeanWrap wrap = context.wrap((String)entry.getKey(), (Object)client);
            context.beanRegister(wrap, (String)entry.getKey(), true);
            DsUtils.observeDs((AppContext)context, (String)dsName, beanWrap -> {
                SolonDataSourceManagerWrap sourceManagerWrap = (SolonDataSourceManagerWrap)client.getConfig().getDataSourceManager();
                sourceManagerWrap.setDataSourceManager(new SolonDataSourceManager((DataSource)beanWrap.get()));
            });
        }
        context.getBeanAsync(ITypeHandler.class, TypeHandlerManager::set);
        this.registerAot(context);
    }

    private void registerAot(AppContext context) {
        if (NativeDetector.isAotRuntime() && ClassUtil.hasClass(() -> RuntimeNativeRegistrar.class)) {
            context.wrapAndPut(SQLinkRuntimeNativeRegistrar.class, (Object)new SQLinkRuntimeNativeRegistrar());
        }
    }
}

