/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.noear.solon.data.sqlink.base.transaction.Transaction;
import org.noear.solon.data.sqlink.base.transaction.TransactionManager;

public class DefaultTransaction
implements Transaction {
    protected Connection connection;
    protected final DataSource dataSource;
    protected final Integer isolationLevel;
    protected final TransactionManager manager;

    public DefaultTransaction(Integer isolationLevel, DataSource dataSource, TransactionManager manager) {
        this.isolationLevel = isolationLevel;
        this.dataSource = dataSource;
        this.manager = manager;
    }

    @Override
    public Integer getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public void commit() {
        try {
            this.connection.commit();
            this.close();
        }
        catch (SQLException e) {
            this.rollback();
            throw new RuntimeException(e);
        }
        finally {
            this.clear();
        }
    }

    @Override
    public void rollback() {
        try {
            this.connection.rollback();
            this.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.clear();
        }
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.clear();
        }
    }

    protected void clear() {
        this.manager.remove();
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.dataSource.getConnection();
        }
        this.connection.setAutoCommit(false);
        if (this.isolationLevel != null) {
            this.connection.setTransactionIsolation(this.isolationLevel);
        }
        return this.connection;
    }
}

